/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.core.behavior;

import com.tttsaurus.fluidintetweaker.common.core.behavior.BehaviorEventType;
import com.tttsaurus.fluidintetweaker.common.core.behavior.condition.IEventCondition;
import com.tttsaurus.fluidintetweaker.common.core.util.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BehaviorEvent {
    private final BehaviorEventType eventType;
    private final List<IEventCondition> conditions = new ArrayList<IEventCondition>();
    private PotionEffect potionEffect;
    private String entityIDFrom;
    private EntityEntry entityEntryFrom;
    private EntityEntry entityEntryTo;
    private int xRange;
    private int yRange;
    private List<IBlockState> blockStates;

    public BehaviorEventType getEventType() {
        return this.eventType;
    }

    public List<IEventCondition> getConditions() {
        return this.conditions;
    }

    public PotionEffect getPotionEffect() {
        return this.potionEffect;
    }

    public String getEntityIDFrom() {
        return this.entityIDFrom;
    }

    public EntityEntry getEntityEntryFrom() {
        return this.entityEntryFrom;
    }

    public EntityEntry getEntityEntryTo() {
        return this.entityEntryTo;
    }

    public int getXRange() {
        return this.xRange;
    }

    public int getYRange() {
        return this.yRange;
    }

    public List<IBlockState> getBlockStates() {
        return this.blockStates;
    }

    private BehaviorEvent(BehaviorEventType eventType) {
        this.eventType = eventType;
    }

    public static BehaviorEvent createPotionEffectEvent(String id, int duration, int amplifier) {
        BehaviorEvent event = new BehaviorEvent(BehaviorEventType.PotionEffect);
        event.potionEffect = new PotionEffect(Potion.func_180142_b((String)id), duration, amplifier);
        return event;
    }

    public static BehaviorEvent createEntityConversionEvent(String idFrom, String idTo) {
        BehaviorEvent event = new BehaviorEvent(BehaviorEventType.EntityConversion);
        event.entityIDFrom = idFrom;
        event.entityEntryFrom = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(idFrom));
        event.entityEntryTo = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(idTo));
        return event;
    }

    public static BehaviorEvent createEntityConversionEvent(EntityEntry entityEntryFrom, EntityEntry entityEntryTo) {
        BehaviorEvent event = new BehaviorEvent(BehaviorEventType.EntityConversion);
        event.entityIDFrom = entityEntryFrom.getRegistryName().toString();
        event.entityEntryFrom = entityEntryFrom;
        event.entityEntryTo = entityEntryTo;
        return event;
    }

    public static BehaviorEvent createExtinguishFireEvent() {
        BehaviorEvent event = new BehaviorEvent(BehaviorEventType.ExtinguishFire);
        return event;
    }

    public static BehaviorEvent createSetFireEvent() {
        BehaviorEvent event = new BehaviorEvent(BehaviorEventType.SetFire);
        return event;
    }

    public static BehaviorEvent createSetSnowEvent() {
        BehaviorEvent event = new BehaviorEvent(BehaviorEventType.SetSnow);
        return event;
    }

    public static BehaviorEvent createTeleportEvent(int xRange, int yRange) {
        BehaviorEvent event = new BehaviorEvent(BehaviorEventType.Teleport);
        event.xRange = xRange;
        event.yRange = yRange;
        return event;
    }

    public static BehaviorEvent createBreakSurroundingEvent(Ingredient ingredient) {
        BehaviorEvent event = new BehaviorEvent(BehaviorEventType.BreakSurrounding);
        event.blockStates = new ArrayList<IBlockState>();
        for (ItemStack itemStack : ingredient.func_193365_a()) {
            event.blockStates.add(BlockUtils.getBlockState(itemStack));
        }
        return event;
    }

    public BehaviorEvent addCondition(IEventCondition condition) {
        this.conditions.add(condition);
        return this;
    }
}

