/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.core.behavior;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredientType;
import com.tttsaurus.fluidintetweaker.common.core.behavior.BehaviorEvent;
import com.tttsaurus.fluidintetweaker.common.core.behavior.BehaviorEventType;
import com.tttsaurus.fluidintetweaker.common.core.behavior.condition.IEventCondition;
import com.tttsaurus.fluidintetweaker.common.core.delegate.IFluidBehaviorDelegate;
import com.tttsaurus.fluidintetweaker.common.core.event.CustomFluidBehaviorEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ComplexOutput {
    private final List<BehaviorEvent> events = new ArrayList<BehaviorEvent>();
    private static final EnumSet<EnumFacing> surrounding = EnumSet.of(EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST);

    public List<BehaviorEvent> getEvents() {
        return this.events;
    }

    private ComplexOutput() {
    }

    public static ComplexOutput create() {
        return new ComplexOutput();
    }

    public ComplexOutput addEvent(BehaviorEvent event) {
        this.events.add(event);
        return this;
    }

    public IFluidBehaviorDelegate getOutputDelegate(final CustomFluidBehaviorEvent fluidBehaviorEvent) {
        final World world = fluidBehaviorEvent.getWorld();
        final BlockPos pos = fluidBehaviorEvent.getPos();
        final EntityLivingBase entityLivingBase = fluidBehaviorEvent.getEntityLivingBase();
        return new IFluidBehaviorDelegate(){

            @Override
            public void doAction() {
                if (world.field_72995_K) {
                    return;
                }
                for (BehaviorEvent event : ComplexOutput.this.events) {
                    WorldIngredient neighbor;
                    BlockPos upperNeighborPos;
                    BlockPos neighborPos;
                    int y;
                    Object rl;
                    IEventCondition condition;
                    List<IEventCondition> conditions = event.getConditions();
                    boolean flag = true;
                    Iterator<IEventCondition> iterator = conditions.iterator();
                    while (iterator.hasNext() && (flag = (condition = iterator.next()).judge(fluidBehaviorEvent))) {
                    }
                    if (!flag) continue;
                    BehaviorEventType eventType = event.getEventType();
                    if (eventType == BehaviorEventType.PotionEffect) {
                        if (entityLivingBase == null) continue;
                        PotionEffect potionEffect = event.getPotionEffect();
                        entityLivingBase.func_70690_d(new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b(), potionEffect.func_76458_c()));
                        continue;
                    }
                    if (eventType == BehaviorEventType.EntityConversion) {
                        if (entityLivingBase == null || (rl = EntityList.func_191301_a((Entity)entityLivingBase)) == null || !rl.toString().equals(event.getEntityIDFrom())) continue;
                        double x = entityLivingBase.field_70169_q;
                        double y2 = entityLivingBase.field_70167_r;
                        double z = entityLivingBase.field_70166_s;
                        entityLivingBase.func_70106_y();
                        Entity entity = event.getEntityEntryTo().newInstance(world);
                        entity.func_70107_b(x, y2, z);
                        world.func_72838_d(entity);
                        continue;
                    }
                    if (eventType == BehaviorEventType.ExtinguishFire) {
                        rl = surrounding.iterator();
                        while (rl.hasNext()) {
                            BlockPos neighborPos2;
                            EnumFacing facing = (EnumFacing)rl.next();
                            Vec3i vec3 = facing.func_176730_m();
                            int x = vec3.func_177958_n();
                            y = vec3.func_177956_o();
                            int z = vec3.func_177952_p();
                            BlockPos neighborPos1 = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                            if (world.func_180495_p(neighborPos1).func_177230_c() == Blocks.field_150480_ab) {
                                world.func_175698_g(neighborPos1);
                            }
                            if (world.func_180495_p(neighborPos2 = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y + 1, pos.func_177952_p() + z)).func_177230_c() != Blocks.field_150480_ab) continue;
                            world.func_175698_g(neighborPos2);
                        }
                        continue;
                    }
                    if (eventType == BehaviorEventType.SetFire) {
                        rl = surrounding.iterator();
                        while (rl.hasNext()) {
                            EnumFacing facing = (EnumFacing)rl.next();
                            Vec3i vec3 = facing.func_176730_m();
                            int x = vec3.func_177958_n();
                            y = vec3.func_177956_o();
                            int z = vec3.func_177952_p();
                            neighborPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                            upperNeighborPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y + 1, pos.func_177952_p() + z);
                            neighbor = WorldIngredient.getFrom(world, neighborPos);
                            if (neighbor == WorldIngredient.AIR || neighbor.getIngredientType() != WorldIngredientType.BLOCK || world.func_180495_p(upperNeighborPos).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(neighborPos).func_177230_c() == Blocks.field_150480_ab) continue;
                            world.func_175656_a(upperNeighborPos, Blocks.field_150480_ab.func_176223_P());
                        }
                        continue;
                    }
                    if (eventType == BehaviorEventType.SetSnow) {
                        rl = surrounding.iterator();
                        while (rl.hasNext()) {
                            EnumFacing facing = (EnumFacing)rl.next();
                            Vec3i vec3 = facing.func_176730_m();
                            int x = vec3.func_177958_n();
                            y = vec3.func_177956_o();
                            int z = vec3.func_177952_p();
                            neighborPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                            upperNeighborPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y + 1, pos.func_177952_p() + z);
                            neighbor = WorldIngredient.getFrom(world, neighborPos);
                            if (neighbor == WorldIngredient.AIR || neighbor.getIngredientType() != WorldIngredientType.BLOCK || world.func_180495_p(upperNeighborPos).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(neighborPos).func_177230_c() == Blocks.field_150431_aC) continue;
                            world.func_175656_a(upperNeighborPos, Blocks.field_150431_aC.func_176223_P());
                        }
                        continue;
                    }
                    if (eventType == BehaviorEventType.Teleport) {
                        float y3;
                        if (entityLivingBase == null) continue;
                        float xRange = event.getXRange();
                        float yRange = event.getYRange();
                        float x = world.field_73012_v.nextFloat() * xRange - xRange / 2.0f;
                        if (!entityLivingBase.func_184595_k((double)x, (double)(y3 = world.field_73012_v.nextFloat() * xRange - yRange / 2.0f), entityLivingBase.field_70161_v)) continue;
                        entityLivingBase.func_70107_b((double)x, (double)y3, entityLivingBase.field_70161_v);
                        continue;
                    }
                    if (eventType != BehaviorEventType.BreakSurrounding) continue;
                    for (EnumFacing facing : surrounding) {
                        Vec3i vec3 = facing.func_176730_m();
                        int x = vec3.func_177958_n();
                        y = vec3.func_177956_o();
                        int z = vec3.func_177952_p();
                        neighborPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                        String neighbor2 = WorldIngredient.getFrom(world, neighborPos).toString();
                        for (IBlockState blockState : event.getBlockStates()) {
                            String target = new WorldIngredient(blockState).toString();
                            if (!neighbor2.equals(target)) continue;
                            world.func_175698_g(neighborPos);
                        }
                    }
                }
            }
        };
    }
}

