/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.core.event;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.delegate.IFluidInteractionDelegate;
import com.tttsaurus.fluidintetweaker.common.core.interaction.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.core.interaction.StringRecipeProtocol;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

@Cancelable
public class CustomFluidInteractionEvent
extends WorldEvent {
    private final BlockPos pos;
    private final boolean isFluidAboveAndBelowCase;
    private final boolean isInitiatorAbove;
    private final IBlockState blockStateBeforeInteraction;
    private final WorldIngredient ingredientA;
    private final WorldIngredient ingredientB;
    private final ComplexOutput complexOutput;
    private final IFluidInteractionDelegate delegate;

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean getIsFluidAboveAndBelowCase() {
        return this.isFluidAboveAndBelowCase;
    }

    public boolean getIsInitiatorAbove() {
        return this.isInitiatorAbove;
    }

    public IBlockState getBlockStateBeforeInteraction() {
        return this.blockStateBeforeInteraction;
    }

    public WorldIngredient getIngredientA() {
        return this.ingredientA;
    }

    public WorldIngredient getIngredientB() {
        return this.ingredientB;
    }

    public ComplexOutput getComplexOutput() {
        return this.complexOutput;
    }

    public IFluidInteractionDelegate getDelegate() {
        return this.delegate;
    }

    public String getFluidInteractionRecipeKey() {
        return StringRecipeProtocol.getRecipeKeyFromTwoIngredients(this.ingredientA, this.ingredientB);
    }

    public CustomFluidInteractionEvent(World world, BlockPos pos, boolean isFluidAboveAndBelowCase, boolean isInitiatorAbove, IBlockState blockStateBeforeInteraction, WorldIngredient ingredientA, WorldIngredient ingredientB, ComplexOutput complexOutput) {
        super(world);
        this.pos = pos;
        this.isFluidAboveAndBelowCase = isFluidAboveAndBelowCase;
        this.isInitiatorAbove = isInitiatorAbove;
        this.blockStateBeforeInteraction = blockStateBeforeInteraction;
        this.ingredientA = ingredientA;
        this.ingredientB = ingredientB;
        this.complexOutput = complexOutput;
        this.delegate = complexOutput.getOutputDelegate(this);
    }
}

