/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.core.interaction;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredientType;
import com.tttsaurus.fluidintetweaker.common.core.delegate.IFluidInteractionDelegate;
import com.tttsaurus.fluidintetweaker.common.core.event.CustomFluidInteractionEvent;
import com.tttsaurus.fluidintetweaker.common.core.interaction.InteractionEvent;
import com.tttsaurus.fluidintetweaker.common.core.interaction.InteractionEventType;
import com.tttsaurus.fluidintetweaker.common.core.interaction.condition.IEventCondition;
import com.tttsaurus.fluidintetweaker.common.core.task.SetBlockStateTask;
import com.tttsaurus.fluidintetweaker.common.core.task.TaskScheduler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class ComplexOutput {
    private final List<InteractionEvent> events = new ArrayList<InteractionEvent>();

    public List<InteractionEvent> getEvents() {
        return this.events;
    }

    private ComplexOutput() {
    }

    public static ComplexOutput create() {
        return new ComplexOutput();
    }

    public static ComplexOutput createSimpleBlockOutput(IBlockState blockState) {
        return ComplexOutput.create().addEvent(InteractionEvent.createSetBlockEvent(blockState));
    }

    public ComplexOutput addEvent(InteractionEvent event) {
        this.events.add(event);
        return this;
    }

    public IFluidInteractionDelegate getOutputDelegate(final CustomFluidInteractionEvent fluidInteractionEvent) {
        final World world = fluidInteractionEvent.getWorld();
        final BlockPos pos = fluidInteractionEvent.getPos();
        return new IFluidInteractionDelegate(){

            @Override
            public void doAction() {
                if (world.field_72995_K) {
                    return;
                }
                for (InteractionEvent event : ComplexOutput.this.events) {
                    InteractionEventType eventType;
                    IEventCondition condition;
                    List<IEventCondition> conditions = event.getConditions();
                    boolean flag = true;
                    Iterator<IEventCondition> iterator = conditions.iterator();
                    while (iterator.hasNext() && (flag = (condition = iterator.next()).judge(fluidInteractionEvent))) {
                    }
                    if (!flag) continue;
                    if (event.getSoundEvent() != null) {
                        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), event.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    if (event.getParticleType() != null) {
                        for (int i = 0; i < 10; ++i) {
                            world.func_175688_a(event.getParticleType(), (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), 0.0, 0.1, 0.0, new int[0]);
                        }
                    }
                    if ((eventType = event.getEventType()) == InteractionEventType.SetBlock) {
                        world.func_175656_a(pos, event.getBlockState());
                        continue;
                    }
                    if (eventType == InteractionEventType.Explosion) {
                        world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), event.getStrength(), event.getDamagesTerrain()).func_77279_a(event.getHasParticles());
                        continue;
                    }
                    if (eventType == InteractionEventType.SpawnEntity) {
                        Entity entity = event.getEntityEntry().newInstance(world);
                        entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        world.func_72838_d(entity);
                        continue;
                    }
                    if (eventType == InteractionEventType.SpawnEntityItem) {
                        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), event.getItemStack().func_77946_l());
                        world.func_72838_d((Entity)entityItem);
                        continue;
                    }
                    if (eventType != InteractionEventType.SetFluid) continue;
                    Fluid fluid = event.getFluid();
                    String fluidName = fluid.getName();
                    IBlockState blockState = fluid.getBlock().func_176223_P();
                    WorldIngredient ingredientB = fluidInteractionEvent.getIngredientB();
                    if (ingredientB.getIngredientType() == WorldIngredientType.FLUID && ingredientB.getFluid().getName().equals(fluidName) && (event.getIsSpreadingUpward() || !fluidInteractionEvent.getIsInitiatorAbove())) {
                        boolean goUp = event.getIsSpreadingUpward() && fluidInteractionEvent.getIsInitiatorAbove();
                        BlockPos finalPos = goUp ? pos.func_177982_a(0, 1, 0) : pos;
                        TaskScheduler.scheduleTask(new SetBlockStateTask(10, world, finalPos, blockState, 3));
                        continue;
                    }
                    world.func_175656_a(pos, blockState);
                }
            }
        };
    }
}

