/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.core.interaction;

import com.tttsaurus.fluidintetweaker.common.core.interaction.InteractionEventType;
import com.tttsaurus.fluidintetweaker.common.core.interaction.condition.IEventCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class InteractionEvent {
    private final InteractionEventType eventType;
    private final List<IEventCondition> conditions = new ArrayList<IEventCondition>();
    private IBlockState blockState;
    private float strength;
    private boolean damagesTerrain;
    private boolean hasParticles;
    private EntityEntry entityEntry;
    private ItemStack itemStack;
    private Fluid fluid;
    private boolean isSpreadingUpward = false;
    private SoundEvent soundEvent = null;
    private EnumParticleTypes particleType = null;

    public InteractionEventType getEventType() {
        return this.eventType;
    }

    public List<IEventCondition> getConditions() {
        return this.conditions;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public float getStrength() {
        return this.strength;
    }

    public boolean getDamagesTerrain() {
        return this.damagesTerrain;
    }

    public boolean getHasParticles() {
        return this.hasParticles;
    }

    public EntityEntry getEntityEntry() {
        return this.entityEntry;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean getIsSpreadingUpward() {
        return this.isSpreadingUpward;
    }

    private InteractionEvent(InteractionEventType eventType) {
        this.eventType = eventType;
    }

    public static InteractionEvent createSetBlockEvent(IBlockState blockState) {
        InteractionEvent event = new InteractionEvent(InteractionEventType.SetBlock);
        event.blockState = blockState;
        return event;
    }

    public static InteractionEvent createExplosionEvent(float strength, boolean damagesTerrain, boolean hasParticles) {
        InteractionEvent event = new InteractionEvent(InteractionEventType.Explosion);
        event.strength = strength;
        event.damagesTerrain = damagesTerrain;
        event.hasParticles = hasParticles;
        return event;
    }

    public static InteractionEvent createSpawnEntityEvent(String id) {
        InteractionEvent event = new InteractionEvent(InteractionEventType.SpawnEntity);
        event.entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
        return event;
    }

    public static InteractionEvent createSpawnEntityEvent(EntityEntry entityEntry) {
        InteractionEvent event = new InteractionEvent(InteractionEventType.SpawnEntity);
        event.entityEntry = entityEntry;
        return event;
    }

    public static InteractionEvent createSpawnEntityItemEvent(ItemStack itemStack, int amount) {
        InteractionEvent event = new InteractionEvent(InteractionEventType.SpawnEntityItem);
        itemStack.func_190920_e(amount);
        event.itemStack = itemStack.func_77946_l();
        return event;
    }

    public static InteractionEvent createSetFluidEvent(Fluid fluid, boolean isSpreadingUpward) {
        InteractionEvent event = new InteractionEvent(InteractionEventType.SetFluid);
        event.fluid = fluid;
        event.isSpreadingUpward = isSpreadingUpward;
        return event;
    }

    public static InteractionEvent createSetFluidEvent(Fluid fluid) {
        InteractionEvent event = new InteractionEvent(InteractionEventType.SetFluid);
        event.fluid = fluid;
        return event;
    }

    public InteractionEvent addCondition(IEventCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public EnumParticleTypes getParticleType() {
        return this.particleType;
    }

    public InteractionEvent setSoundEvent(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
        return this;
    }

    public InteractionEvent setParticleType(EnumParticleTypes particleType) {
        this.particleType = particleType;
        return this;
    }
}

