/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.core.task;

import com.tttsaurus.fluidintetweaker.common.core.task.BaseTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class TaskScheduler {
    private static final List<BaseTask> tasks = new ArrayList<BaseTask>();
    private static final List<BaseTask> toRun = new ArrayList<BaseTask>();
    private static final List<Integer> toRunIndexes = new ArrayList<Integer>();
    private static final List<Integer> toRemove = new ArrayList<Integer>();
    private static final int maxDeferTickNum = 3;
    private static final int triggerDeferTaskNum = 10;

    public static void scheduleTask(BaseTask task) {
        tasks.add(task);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (tasks.isEmpty()) {
            return;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            BaseTask task = tasks.get(i);
            --task.delay;
            if (task.delay > 0) continue;
            toRun.add(task);
            toRunIndexes.add(i);
        }
        int length = toRun.size();
        if (length > 1) {
            BaseTask task;
            int redundantCount = 0;
            int uniqueTaskCount = 0;
            int deferredCount = 0;
            boolean[] used = new boolean[length];
            Arrays.fill(used, false);
            int i = 0;
            int j = 0;
            for (i = 0; i < length; ++i) {
                task = toRun.get(i);
                if (used[i]) continue;
                for (j = i; j < length; ++j) {
                    if (j == i || used[j] || !task.deferrable || !task.compare(toRun.get(j))) continue;
                    used[j] = true;
                    ++redundantCount;
                }
            }
            uniqueTaskCount = length - redundantCount;
            j = 0;
            for (i = 0; i < length; ++i) {
                task = toRun.get(i);
                if (!used[i]) {
                    if (j < 10 || !task.deferrable) {
                        task.run();
                        toRemove.add(toRunIndexes.get(i));
                    } else {
                        task.deferrable = false;
                        task.delay += (int)((float)(j + 1) / (float)uniqueTaskCount * 3.0f);
                        ++deferredCount;
                    }
                    ++j;
                    continue;
                }
                toRemove.add(toRunIndexes.get(i));
            }
            for (i = toRemove.size() - 1; i >= 0; --i) {
                tasks.remove(toRemove.get(i));
            }
            toRemove.clear();
        } else if (length == 1) {
            toRun.get(0).run();
            tasks.remove(toRunIndexes.get(0));
        }
        toRun.clear();
        toRunIndexes.clear();
    }
}

