/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.core.util;

import java.util.HashMap;

public class CachedContainsKeyMap<K, V>
extends HashMap<K, V> {
    private Object cachedKey = null;
    private V cachedValue = null;
    private boolean cachedKeyExists = false;

    @Override
    public boolean containsKey(Object key) {
        if (key.equals(this.cachedKey)) {
            return this.cachedKeyExists;
        }
        this.cachedKey = key;
        this.cachedValue = super.get(key);
        this.cachedKeyExists = this.cachedValue != null;
        return this.cachedKeyExists;
    }

    @Override
    public V get(Object key) {
        if (key.equals(this.cachedKey)) {
            return this.cachedValue;
        }
        return super.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key.equals(this.cachedKey)) {
            this.cachedKey = null;
        }
        return super.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key.equals(this.cachedKey)) {
            this.cachedKey = null;
        }
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.cachedKey = null;
        super.clear();
    }
}

