/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.impl.behavior;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.behavior.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.core.event.CustomFluidBehaviorEvent;
import com.tttsaurus.fluidintetweaker.common.impl.behavior.FluidBehaviorRecipeManager;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class FluidBehaviorLogic {
    private static final EnumSet<EnumFacing> surrounding = EnumSet.of(EnumFacing.NORTH, new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN});

    @SubscribeEvent
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        WorldIngredient ingredient = WorldIngredient.getFrom(world, pos);
        if (FluidBehaviorRecipeManager.recipeExists(ingredient)) {
            ComplexOutput complexOutput = FluidBehaviorRecipeManager.getRecipeOutput(ingredient);
            MinecraftForge.EVENT_BUS.post((Event)new CustomFluidBehaviorEvent(world, pos, null, ingredient, complexOutput));
        }
        for (EnumFacing facing : surrounding) {
            Vec3i vec3 = facing.func_176730_m();
            int x = vec3.func_177958_n();
            int y = vec3.func_177956_o();
            int z = vec3.func_177952_p();
            BlockPos neighborPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
            WorldIngredient neighborIngredient = WorldIngredient.getFrom(world, neighborPos);
            if (!FluidBehaviorRecipeManager.recipeExists(neighborIngredient)) continue;
            ComplexOutput complexOutput = FluidBehaviorRecipeManager.getRecipeOutput(neighborIngredient);
            MinecraftForge.EVENT_BUS.post((Event)new CustomFluidBehaviorEvent(world, neighborPos, null, neighborIngredient, complexOutput));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        World world = entityLivingBase.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = new BlockPos((Entity)entityLivingBase);
        WorldIngredient ingredient = WorldIngredient.getFrom(world, pos);
        if (!FluidBehaviorRecipeManager.recipeExists(ingredient)) {
            return;
        }
        ComplexOutput complexOutput = FluidBehaviorRecipeManager.getRecipeOutput(ingredient);
        MinecraftForge.EVENT_BUS.post((Event)new CustomFluidBehaviorEvent(world, pos, entityLivingBase, ingredient, complexOutput));
    }
}

