/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.impl.behavior;

import com.tttsaurus.fluidintetweaker.FluidInteractionTweaker;
import com.tttsaurus.fluidintetweaker.client.impl.jefb.JEFBPlugin;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.behavior.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.core.behavior.FluidBehaviorRecipe;
import com.tttsaurus.fluidintetweaker.common.core.exception.FITweakerRuntimeException;
import com.tttsaurus.fluidintetweaker.common.core.util.CachedContainsKeyMap;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class FluidBehaviorRecipeManager {
    public static boolean autoAddJEIRecipe = true;
    private static final CachedContainsKeyMap<String, ComplexOutput> recipeDict = new CachedContainsKeyMap();

    static boolean recipeExists(WorldIngredient ingredient) {
        return recipeDict.containsKey(ingredient.toString());
    }

    static ComplexOutput getRecipeOutput(WorldIngredient ingredient) {
        return recipeDict.get(ingredient.toString());
    }

    public static String addRecipe(FluidBehaviorRecipe recipe) throws FITweakerRuntimeException {
        String key = recipe.ingredient.toString();
        if (recipeDict.containsKey(key)) {
            throw new FITweakerRuntimeException("FluidBehaviorRecipeManager.addRecipe() fails to execute. The same recipe key " + key + " has been added.");
        }
        recipeDict.put(key, recipe.complexOutput);
        if (FluidInteractionTweaker.IS_JEI_LOADED && autoAddJEIRecipe && FMLCommonHandler.instance().getSide().isClient()) {
            JEFBPlugin.addRecipeWrapper(recipe);
        }
        return key;
    }

    public static void removeRecipe(FluidBehaviorRecipe recipe) throws FITweakerRuntimeException {
        String key = recipe.ingredient.toString();
        if (!recipeDict.containsKey(key)) {
            throw new FITweakerRuntimeException("FluidBehaviorRecipeManager.removeRecipe() fails to execute. The recipe key " + key + " being removed doesn't exist.");
        }
        recipeDict.remove(key);
    }

    public static void removeAllRecipes() {
        recipeDict.clear();
    }
}

