/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.impl.interaction;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredientType;
import com.tttsaurus.fluidintetweaker.common.core.event.CustomFluidInteractionEvent;
import com.tttsaurus.fluidintetweaker.common.core.interaction.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.impl.interaction.FluidInteractionRecipeManager;
import java.util.EnumSet;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class FluidInteractionLogic {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        WorldIngredient ingredient1 = WorldIngredient.getFrom(world, pos);
        if (!FluidInteractionRecipeManager.ingredientAExists(ingredient1) && !FluidInteractionRecipeManager.ingredientBExists(ingredient1)) {
            return;
        }
        EnumSet sides = event.getNotifiedSides();
        for (EnumFacing facing : sides) {
            ComplexOutput complexOutput;
            WorldIngredient ingredientB;
            WorldIngredient ingredientA;
            ComplexOutput complexOutput2;
            Vec3i vec3 = facing.func_176730_m();
            int x = vec3.func_177958_n();
            int y = vec3.func_177956_o();
            int z = vec3.func_177952_p();
            BlockPos neighborPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
            WorldIngredient ingredient2 = WorldIngredient.getFrom(world, neighborPos);
            if (ingredient1.getIngredientType() == WorldIngredientType.FLUID && ingredient2.getIngredientType() == WorldIngredientType.FLUID && facing == EnumFacing.DOWN) {
                ingredient1.setIsFluidSource(false);
                complexOutput2 = FluidInteractionRecipeManager.getRecipeOutput(ingredient1, ingredient2);
                if (complexOutput2 == null) {
                    ingredientA = ingredient2;
                    ingredientB = ingredient1;
                } else {
                    ingredientA = ingredient1;
                    ingredientB = ingredient2;
                }
                ComplexOutput complexOutput3 = complexOutput2 = complexOutput2 == null ? FluidInteractionRecipeManager.getRecipeOutput(ingredient2, ingredient1) : complexOutput2;
                if (complexOutput2 == null) continue;
                MinecraftForge.EVENT_BUS.post((Event)new CustomFluidInteractionEvent(world, neighborPos, true, ingredientA.equals(ingredient1), world.func_180495_p(neighborPos), ingredientA, ingredientB, complexOutput2));
                continue;
            }
            if (FluidInteractionRecipeManager.recipeExists(ingredient1, ingredient2)) {
                complexOutput = FluidInteractionRecipeManager.getRecipeOutput(ingredient1, ingredient2);
                MinecraftForge.EVENT_BUS.post((Event)new CustomFluidInteractionEvent(world, pos, false, facing == EnumFacing.DOWN, world.func_180495_p(pos), ingredient1, ingredient2, complexOutput));
                continue;
            }
            if (ingredient2.getIngredientType() == WorldIngredientType.FLUID && ingredient1.getIngredientType() == WorldIngredientType.FLUID && facing == EnumFacing.UP) {
                ingredient2.setIsFluidSource(false);
                complexOutput2 = FluidInteractionRecipeManager.getRecipeOutput(ingredient2, ingredient1);
                if (complexOutput2 == null) {
                    ingredientA = ingredient1;
                    ingredientB = ingredient2;
                } else {
                    ingredientA = ingredient2;
                    ingredientB = ingredient1;
                }
                ComplexOutput complexOutput4 = complexOutput2 = complexOutput2 == null ? FluidInteractionRecipeManager.getRecipeOutput(ingredient1, ingredient2) : complexOutput2;
                if (complexOutput2 == null) continue;
                MinecraftForge.EVENT_BUS.post((Event)new CustomFluidInteractionEvent(world, pos, true, ingredientA.equals(ingredient2), world.func_180495_p(pos), ingredientA, ingredientB, complexOutput2));
                continue;
            }
            if (!FluidInteractionRecipeManager.recipeExists(ingredient2, ingredient1)) continue;
            complexOutput = FluidInteractionRecipeManager.getRecipeOutput(ingredient2, ingredient1);
            MinecraftForge.EVENT_BUS.post((Event)new CustomFluidInteractionEvent(world, neighborPos, false, facing == EnumFacing.UP, world.func_180495_p(neighborPos), ingredient2, ingredient1, complexOutput));
        }
    }
}

