/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.common.impl.interaction.condition;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredientType;
import com.tttsaurus.fluidintetweaker.common.core.event.CustomFluidInteractionEvent;
import com.tttsaurus.fluidintetweaker.common.core.interaction.FluidInteractionRecipe;
import com.tttsaurus.fluidintetweaker.common.core.interaction.condition.IEventCondition;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.resources.I18n;

public class FluidLevel
implements IEventCondition {
    private final int fluidIndex;
    private final int level;

    public FluidLevel(int fluidIndex, int level) {
        this.fluidIndex = fluidIndex;
        this.level = level;
    }

    @Override
    public boolean judge(CustomFluidInteractionEvent fluidInteractionEvent) {
        if (this.fluidIndex == 0 && fluidInteractionEvent.getIngredientA().getIngredientType() == WorldIngredientType.FLUID) {
            return (Integer)fluidInteractionEvent.getIngredientA().getBlockState().func_177229_b((IProperty)BlockLiquid.field_176367_b) == this.level;
        }
        if (this.fluidIndex == 1 && fluidInteractionEvent.getIngredientB().getIngredientType() == WorldIngredientType.FLUID) {
            return (Integer)fluidInteractionEvent.getIngredientB().getBlockState().func_177229_b((IProperty)BlockLiquid.field_176367_b) == this.level;
        }
        return false;
    }

    @Override
    public String getDesc(FluidInteractionRecipe recipe) {
        if (this.fluidIndex == 0 && recipe.ingredientA.getIngredientType() == WorldIngredientType.FLUID) {
            return I18n.func_135052_a((String)"fluidintetweaker.jefi.condition.fluid_level", (Object[])new Object[]{I18n.func_135052_a((String)recipe.ingredientA.getFluid().getUnlocalizedName(), (Object[])new Object[0]), this.level});
        }
        if (this.fluidIndex == 1 && recipe.ingredientB.getIngredientType() == WorldIngredientType.FLUID) {
            return I18n.func_135052_a((String)"fluidintetweaker.jefi.condition.fluid_level", (Object[])new Object[]{I18n.func_135052_a((String)recipe.ingredientB.getFluid().getUnlocalizedName(), (Object[])new Object[0]), this.level});
        }
        return null;
    }
}

