/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.plugin.crt.impl;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.behavior.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.core.behavior.FluidBehaviorRecipe;
import com.tttsaurus.fluidintetweaker.common.core.exception.FITweakerRuntimeException;
import com.tttsaurus.fluidintetweaker.common.impl.behavior.FluidBehaviorRecipeManager;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import youyihj.zenutils.api.reload.Reloadable;

public final class FBTActions {

    @Reloadable
    public static final class AddRecipesAction
    implements IAction {
        private final List<FluidBehaviorRecipe> recipeList = new ArrayList<FluidBehaviorRecipe>();
        public final List<String> recipeKeys = new ArrayList<String>();

        private static WorldIngredient buildIngredient(ILiquidStack liquidStack, boolean isSource) {
            return new WorldIngredient(((FluidStack)liquidStack.getInternal()).getFluid(), isSource);
        }

        public AddRecipesAction(ILiquidStack liquid, boolean isSource, ComplexOutput complexOutput) {
            this.recipeList.add(new FluidBehaviorRecipe(AddRecipesAction.buildIngredient(liquid, isSource), complexOutput));
        }

        public AddRecipesAction(ILiquidStack liquid, ComplexOutput complexOutput) {
            this.recipeList.add(new FluidBehaviorRecipe(AddRecipesAction.buildIngredient(liquid, true), complexOutput));
            this.recipeList.add(new FluidBehaviorRecipe(AddRecipesAction.buildIngredient(liquid, false), complexOutput));
        }

        public void undo() throws FITweakerRuntimeException {
            for (FluidBehaviorRecipe recipe : this.recipeList) {
                FluidBehaviorRecipeManager.removeRecipe(recipe);
            }
        }

        public void apply() throws FITweakerRuntimeException {
            for (FluidBehaviorRecipe recipe : this.recipeList) {
                this.recipeKeys.add(FluidBehaviorRecipeManager.addRecipe(recipe));
            }
        }

        public String describe() {
            StringBuilder builder = new StringBuilder();
            builder.append("Added fluid behavior recipe(s): ");
            int length = this.recipeList.size();
            for (int i = 0; i < length; ++i) {
                FluidBehaviorRecipe recipe = this.recipeList.get(i);
                builder.append(recipe.ingredient.toString());
                if (i == length - 1) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
    }
}

