/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.plugin.crt.impl;

import com.tttsaurus.fluidintetweaker.client.impl.jefb.JEFBPlugin;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.behavior.BehaviorEvent;
import com.tttsaurus.fluidintetweaker.common.core.behavior.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.impl.behavior.FluidBehaviorRecipeManager;
import com.tttsaurus.fluidintetweaker.common.impl.behavior.condition.ByChance;
import com.tttsaurus.fluidintetweaker.plugin.crt.impl.FBTActions;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.oredict.OreIngredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenRegister
@ZenClass(value="mods.fluidintetweaker.FBTweaker")
public final class FBTweaker {
    @ZenMethod
    public static ComplexOutputBuilder outputBuilder() {
        return new ComplexOutputBuilder();
    }

    @ZenMethod
    public static BehaviorEventBuilder eventBuilder() {
        return new BehaviorEventBuilder();
    }

    @ZenMethod
    public static List<String> addRecipe(ILiquidStack liquid, boolean isSource, ComplexOutputBuilder complexOutputBuilder) {
        FBTActions.AddRecipesAction action = new FBTActions.AddRecipesAction(liquid, isSource, complexOutputBuilder.done());
        CraftTweakerAPI.apply((IAction)action);
        return action.recipeKeys;
    }

    @ZenMethod
    public static List<String> addRecipe(ILiquidStack liquid, ComplexOutputBuilder complexOutputBuilder) {
        FBTActions.AddRecipesAction action = new FBTActions.AddRecipesAction(liquid, complexOutputBuilder.done());
        CraftTweakerAPI.apply((IAction)action);
        return action.recipeKeys;
    }

    private static WorldIngredient buildIngredient(ILiquidStack liquidStack, boolean isSource) {
        return new WorldIngredient(((FluidStack)liquidStack.getInternal()).getFluid(), isSource);
    }

    @ZenMethod
    public static void autoAddJEIRecipe(boolean flag) {
        FluidBehaviorRecipeManager.autoAddJEIRecipe = flag;
    }

    @ZenMethod
    public static void addJEIRecipeWrapper(ILiquidStack liquid, int fluidState, ComplexOutputBuilder complexOutputBuilder) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            JEFBPlugin.addRecipeWrapper(FBTweaker.buildIngredient(liquid, fluidState == 0), fluidState == 2, complexOutputBuilder.done());
        }
    }

    @ZenRegister
    @ZenClass(value="mods.fluidintetweaker.behavior.ComplexOutputBuilder")
    public static class ComplexOutputBuilder {
        private final ComplexOutput complexOutput = ComplexOutput.create();

        @ZenMethod
        public ComplexOutputBuilder addEvent(BehaviorEventBuilder eventBuilder) {
            BehaviorEvent event = eventBuilder.done();
            if (event == null) {
                return this;
            }
            this.complexOutput.addEvent(event);
            return this;
        }

        public ComplexOutput done() {
            return this.complexOutput;
        }
    }

    @ZenRegister
    @ZenClass(value="mods.fluidintetweaker.behavior.BehaviorEventBuilder")
    public static class BehaviorEventBuilder {
        private BehaviorEvent behaviorEvent = null;

        @ZenMethod
        public BehaviorEventBuilder createPotionEffectEvent(String id, int duration, int amplifier) {
            this.behaviorEvent = BehaviorEvent.createPotionEffectEvent(id, duration, amplifier);
            return this;
        }

        @ZenMethod
        public BehaviorEventBuilder createEntityConversionEvent(IEntityDefinition entityDefinitionFrom, IEntityDefinition entityDefinitionTo) {
            this.behaviorEvent = BehaviorEvent.createEntityConversionEvent((EntityEntry)entityDefinitionFrom.getInternal(), (EntityEntry)entityDefinitionTo.getInternal());
            return this;
        }

        @ZenMethod
        public BehaviorEventBuilder createExtinguishFireEvent() {
            this.behaviorEvent = BehaviorEvent.createExtinguishFireEvent();
            return this;
        }

        @ZenMethod
        public BehaviorEventBuilder createSetFireEvent() {
            this.behaviorEvent = BehaviorEvent.createSetFireEvent();
            return this;
        }

        @ZenMethod
        public BehaviorEventBuilder createSetSnowEvent() {
            this.behaviorEvent = BehaviorEvent.createSetSnowEvent();
            return this;
        }

        @ZenMethod
        public BehaviorEventBuilder createTeleportEvent(int xRange, int yRange) {
            this.behaviorEvent = BehaviorEvent.createTeleportEvent(xRange, yRange);
            return this;
        }

        @ZenMethod
        public BehaviorEventBuilder createBreakSurroundingEvent(IIngredient ingredient) {
            OreIngredient mcIngredient = null;
            if (ingredient instanceof IOreDictEntry) {
                IOreDictEntry oreDictEntry = (IOreDictEntry)ingredient;
                mcIngredient = new OreIngredient(oreDictEntry.getName());
            }
            if (mcIngredient != null) {
                this.behaviorEvent = BehaviorEvent.createBreakSurroundingEvent(mcIngredient);
            }
            return this;
        }

        @ZenMethod
        public BehaviorEventBuilder addCondition(EnumConditionWrapper conditionWrapper, Object[] params) {
            ByChance condition = null;
            EnumCondition enumCondition = conditionWrapper.enumCondition;
            if (enumCondition == EnumCondition.ByChance) {
                condition = new ByChance(((Float)params[0]).floatValue());
            }
            if (condition == null || this.behaviorEvent == null) {
                return this;
            }
            this.behaviorEvent.addCondition(condition);
            return this;
        }

        public BehaviorEvent done() {
            return this.behaviorEvent;
        }
    }

    @ZenRegister
    @ZenClass(value="mods.fluidintetweaker.behavior.Condition")
    public static class EnumConditionWrapper {
        protected final EnumCondition enumCondition;
        @ZenProperty
        public static final EnumConditionWrapper byChance = new EnumConditionWrapper(EnumCondition.ByChance);

        private EnumConditionWrapper(EnumCondition enumCondition) {
            this.enumCondition = enumCondition;
        }
    }

    public static enum EnumCondition {
        ByChance;

    }
}

