/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.plugin.crt.impl;

import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.exception.FITweakerRuntimeException;
import com.tttsaurus.fluidintetweaker.common.core.interaction.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.core.interaction.FluidInteractionRecipe;
import com.tttsaurus.fluidintetweaker.common.core.interaction.StringRecipeProtocol;
import com.tttsaurus.fluidintetweaker.common.impl.interaction.FluidInteractionRecipeManager;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fluids.FluidStack;
import youyihj.zenutils.api.reload.Reloadable;

public final class FITActions {

    @Reloadable
    public static final class AddRecipesAction
    implements IAction {
        private final List<FluidInteractionRecipe> recipeList = new ArrayList<FluidInteractionRecipe>();
        public final List<String> recipeKeys = new ArrayList<String>();

        private static WorldIngredient buildIngredient(ILiquidStack liquidStack, boolean isSource) {
            return new WorldIngredient(((FluidStack)liquidStack.getInternal()).getFluid(), isSource);
        }

        private static WorldIngredient buildIngredient(crafttweaker.api.block.IBlockState blockState) {
            return new WorldIngredient((IBlockState)blockState.getInternal());
        }

        public AddRecipesAction(ILiquidStack liquidInitiator, boolean isSourceA, ILiquidStack liquidSurrounding, boolean isSourceB, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, isSourceA), AddRecipesAction.buildIngredient(liquidSurrounding, isSourceB), complexOutput, extraInfoLocalizationKey));
        }

        public AddRecipesAction(ILiquidStack liquidInitiator, boolean isSourceA, ILiquidStack liquidSurrounding, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, isSourceA), AddRecipesAction.buildIngredient(liquidSurrounding, true), complexOutput, extraInfoLocalizationKey));
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, isSourceA), AddRecipesAction.buildIngredient(liquidSurrounding, false), complexOutput, extraInfoLocalizationKey));
        }

        public AddRecipesAction(ILiquidStack liquidInitiator, ILiquidStack liquidSurrounding, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, true), AddRecipesAction.buildIngredient(liquidSurrounding, true), complexOutput, extraInfoLocalizationKey));
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, true), AddRecipesAction.buildIngredient(liquidSurrounding, false), complexOutput, extraInfoLocalizationKey));
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, false), AddRecipesAction.buildIngredient(liquidSurrounding, true), complexOutput, extraInfoLocalizationKey));
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, false), AddRecipesAction.buildIngredient(liquidSurrounding, false), complexOutput, extraInfoLocalizationKey));
        }

        public AddRecipesAction(ILiquidStack liquidInitiator, boolean isSourceA, crafttweaker.api.block.IBlockState blockSurrounding, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, isSourceA), AddRecipesAction.buildIngredient(blockSurrounding), complexOutput, extraInfoLocalizationKey));
        }

        public AddRecipesAction(ILiquidStack liquidInitiator, crafttweaker.api.block.IBlockState blockSurrounding, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, true), AddRecipesAction.buildIngredient(blockSurrounding), complexOutput, extraInfoLocalizationKey));
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(liquidInitiator, false), AddRecipesAction.buildIngredient(blockSurrounding), complexOutput, extraInfoLocalizationKey));
        }

        public AddRecipesAction(crafttweaker.api.block.IBlockState blockInitiator, ILiquidStack liquidSurrounding, boolean isSourceB, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(blockInitiator), AddRecipesAction.buildIngredient(liquidSurrounding, isSourceB), complexOutput, extraInfoLocalizationKey));
        }

        public AddRecipesAction(crafttweaker.api.block.IBlockState blockInitiator, ILiquidStack liquidSurrounding, ComplexOutput complexOutput, String extraInfoLocalizationKey) {
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(blockInitiator), AddRecipesAction.buildIngredient(liquidSurrounding, true), complexOutput, extraInfoLocalizationKey));
            this.recipeList.add(new FluidInteractionRecipe(AddRecipesAction.buildIngredient(blockInitiator), AddRecipesAction.buildIngredient(liquidSurrounding, false), complexOutput, extraInfoLocalizationKey));
        }

        public void undo() throws FITweakerRuntimeException {
            for (FluidInteractionRecipe recipe : this.recipeList) {
                FluidInteractionRecipeManager.removeRecipe(recipe);
            }
            FluidInteractionRecipeManager.refreshIngredientABLists();
        }

        public void apply() throws FITweakerRuntimeException {
            for (FluidInteractionRecipe recipe : this.recipeList) {
                this.recipeKeys.add(FluidInteractionRecipeManager.addRecipe(recipe));
            }
        }

        public String describe() {
            StringBuilder builder = new StringBuilder();
            builder.append("Added fluid interaction recipe(s): ");
            int length = this.recipeList.size();
            for (int i = 0; i < length; ++i) {
                FluidInteractionRecipe recipe = this.recipeList.get(i);
                builder.append(StringRecipeProtocol.getRecipeKeyFromTwoIngredients(recipe.ingredientA, recipe.ingredientB));
                if (i == length - 1) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
    }
}

