/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluidintetweaker.plugin.grs;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderMethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderRegistrationMethod;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import com.tttsaurus.fluidintetweaker.common.core.WorldIngredient;
import com.tttsaurus.fluidintetweaker.common.core.interaction.ComplexOutput;
import com.tttsaurus.fluidintetweaker.common.core.interaction.FluidInteractionRecipe;
import com.tttsaurus.fluidintetweaker.common.impl.interaction.FluidInteractionRecipeManager;
import com.tttsaurus.fluidintetweaker.plugin.grs.GrSFluidInteractionPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@RegistryDescription(linkGenerator="fluidintetweaker", title="groovyscript.wiki.fluidintetweaker.fitweaker.title", description="groovyscript.wiki.fluidintetweaker.fitweaker.description")
public class FITweaker
extends VirtualizedRegistry<FluidInteractionRecipe> {
    @RecipeBuilderDescription(example={@Example(value=".fluidInitiator(fluid('cobalt')).fluidSurrounding(fluid('water')).outputBlock(block('minecraft:stone'))"), @Example(value=".fluidInitiator(fluid('cobalt'), false).blockSurrounding(block('minecraft:bedrock')).outputBlock(block('minecraft:sand')).extraInfoLocalizationKey('modpack.string.desc')")})
    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    @GroovyBlacklist
    public void onReload() {
        this.removeScripted().forEach(FluidInteractionRecipeManager::removeRecipe);
        this.restoreFromBackup().forEach(FluidInteractionRecipeManager::addRecipe);
    }

    public void add(FluidInteractionRecipe recipe) {
        if (recipe == null) {
            return;
        }
        this.addScripted(recipe);
        FluidInteractionRecipeManager.addRecipe(recipe);
    }

    public static class RecipeBuilder
    extends AbstractRecipeBuilder<List<FluidInteractionRecipe>> {
        private final List<Integer> possibleRecipeTypes = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5));
        private Fluid fluidInitiator;
        private boolean isSourceA;
        private Fluid fluidSurrounding;
        private boolean isSourceB;
        private IBlockState blockSurrounding;
        private IBlockState outputBlock;
        private String extraInfoLocalizationKey;

        private void removePossibleRecipeTypes(Integer ... types) {
            for (Integer type : types) {
                this.possibleRecipeTypes.remove(type);
            }
        }

        @RecipeBuilderMethodDescription
        public RecipeBuilder fluidInitiator(FluidStack fluidStack) {
            this.fluidInitiator = fluidStack.getFluid();
            this.removePossibleRecipeTypes(1, 2, 4);
            return this;
        }

        @RecipeBuilderMethodDescription
        public RecipeBuilder fluidInitiator(FluidStack fluidStack, boolean isSource) {
            this.fluidInitiator = fluidStack.getFluid();
            this.isSourceA = isSource;
            this.removePossibleRecipeTypes(3, 5);
            return this;
        }

        @RecipeBuilderMethodDescription
        public RecipeBuilder fluidSurrounding(FluidStack fluidStack) {
            this.fluidSurrounding = fluidStack.getFluid();
            this.removePossibleRecipeTypes(1, 4, 5);
            return this;
        }

        @RecipeBuilderMethodDescription
        public RecipeBuilder fluidSurrounding(FluidStack fluidStack, boolean isSource) {
            this.fluidSurrounding = fluidStack.getFluid();
            this.isSourceB = isSource;
            this.removePossibleRecipeTypes(2, 3, 4, 5);
            return this;
        }

        @RecipeBuilderMethodDescription
        public RecipeBuilder blockSurrounding(IBlockState blockState) {
            this.blockSurrounding = blockState;
            this.removePossibleRecipeTypes(1, 2, 3);
            return this;
        }

        @RecipeBuilderMethodDescription
        public RecipeBuilder outputBlock(IBlockState blockState) {
            this.outputBlock = blockState;
            return this;
        }

        @RecipeBuilderMethodDescription
        public RecipeBuilder extraInfoLocalizationKey(String key) {
            this.extraInfoLocalizationKey = key;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Fluid Interaction Tweaker recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg);
            this.validateFluids(msg);
            msg.add(this.possibleRecipeTypes.size() != 1, "not a valid type of recipe", new Object[0]);
        }

        @RecipeBuilderRegistrationMethod
        @Nullable
        public List<FluidInteractionRecipe> register() {
            if (!this.validate()) {
                return null;
            }
            ArrayList<FluidInteractionRecipe> recipeList = new ArrayList<FluidInteractionRecipe>();
            int recipeType = this.possibleRecipeTypes.get(0);
            if (recipeType == 1) {
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, this.isSourceA), new WorldIngredient(this.fluidSurrounding, this.isSourceB), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
            } else if (recipeType == 2) {
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, this.isSourceA), new WorldIngredient(this.fluidSurrounding, true), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, this.isSourceA), new WorldIngredient(this.fluidSurrounding, false), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
            } else if (recipeType == 3) {
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, true), new WorldIngredient(this.fluidSurrounding, true), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, true), new WorldIngredient(this.fluidSurrounding, false), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, false), new WorldIngredient(this.fluidSurrounding, true), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, false), new WorldIngredient(this.fluidSurrounding, false), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
            } else if (recipeType == 4) {
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, this.isSourceA), new WorldIngredient(this.blockSurrounding), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
            } else if (recipeType == 5) {
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, true), new WorldIngredient(this.blockSurrounding), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
                recipeList.add(new FluidInteractionRecipe(new WorldIngredient(this.fluidInitiator, false), new WorldIngredient(this.blockSurrounding), ComplexOutput.createSimpleBlockOutput(this.outputBlock), this.extraInfoLocalizationKey));
            }
            for (FluidInteractionRecipe recipe : recipeList) {
                GrSFluidInteractionPlugin.propertyContainerInstance.tweaker.add(recipe);
            }
            return recipeList;
        }
    }
}

