/*
 * Decompiled with CFR 0.152.
 */
package com.iactu.stackcraft;

import com.iactu.stackcraft.Config;
import com.mojang.logging.LogUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import org.slf4j.Logger;

@Mod(value="stackcraft")
public class StackcraftMod {
    public static final String MOD_ID = "stackcraft";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int ABSOLUTE_MAXIMUM_STACK_SIZE = 0x3FFFFFFF;

    public StackcraftMod(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @EventBusSubscriber(modid="stackcraft")
    public static class CommonModEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onModifyDefaultComponentsEvent(ModifyDefaultComponentsEvent event) {
            event.getAllItems().filter(item -> !item.components().has(DataComponents.DAMAGE) && !item.components().has(DataComponents.MAX_DAMAGE) && item.getDefaultMaxStackSize() >= Config.minimumDefaultStackSizeThreshold).forEach(item -> {
                int newDefaultMaxStackSize = Config.respectSmallStackSizes ? Math.clamp((long)item.getDefaultMaxStackSize() * (long)Config.defaultStackSize / 64L, 1, 0x3FFFFFFF) : Config.defaultStackSize;
                event.modify((ItemLike)item, builder -> builder.set(DataComponents.MAX_STACK_SIZE, (Object)newDefaultMaxStackSize));
            });
        }
    }
}

