/*
 * Decompiled with CFR 0.152.
 */
package com.github.rashnain.savemod;

import com.github.rashnain.savemod.SaveMod;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;

public class SaveSummary {
    private final String saveFileName;
    private final String worldDir;
    private final long size;
    private long lastPlayed = -1L;

    public SaveSummary(String saveFileName, String worldDir, long size) {
        this.saveFileName = saveFileName;
        this.worldDir = worldDir;
        this.size = size;
    }

    public String getSaveFileName() {
        return this.saveFileName;
    }

    public String getSaveName() {
        return this.saveFileName.substring(20, this.saveFileName.length() - 4);
    }

    public String getWorldDir() {
        return this.worldDir;
    }

    public long getLastPlayed() {
        if (this.lastPlayed == -1L) {
            Date date;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss").parse(this.saveFileName);
            }
            catch (ParseException e) {
                SaveMod.LOGGER.error("Could not parse save date from '{}' : {}", (Object)this.saveFileName, (Object)e);
                date = Date.from(Instant.EPOCH);
            }
            this.lastPlayed = date.getTime();
        }
        return this.lastPlayed;
    }

    public String getSizeInMB() {
        long megaByte = 1000000L;
        if (this.size < megaByte) {
            return "< 1";
        }
        return String.valueOf(this.size / megaByte);
    }
}

