/*
 * Decompiled with CFR 0.152.
 */
package com.github.rashnain.savemod.config;

import com.github.rashnain.savemod.SaveMod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

public class SaveModConfig {
    public static final class_7172<Boolean> gameMenu = class_7172.method_41749((String)"options.savemod.gameMenu", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.savemod.gameMenu.tooltip")), (boolean)true);
    public static final class_7172<Boolean> worldEntries = class_7172.method_41749((String)"options.savemod.worldEntries", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.savemod.worldEntries.tooltip")), (boolean)false);
    public static final class_7172<Boolean> compression = class_7172.method_41749((String)"options.savemod.compression", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.savemod.compression.tooltip")), (boolean)true);
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("savemod.properties");
    private static final Properties properties = new Properties();

    public static void load() {
        if (Files.notExists(configPath, new LinkOption[0])) {
            SaveModConfig.save();
        } else {
            try {
                properties.load(Files.newInputStream(configPath, new OpenOption[0]));
                gameMenu.method_41748((Object)Boolean.valueOf(properties.getProperty("show-button-on-game-menu", "true")));
                worldEntries.method_41748((Object)Boolean.valueOf(properties.getProperty("show-button-on-world-entries", "false")));
                compression.method_41748((Object)Boolean.valueOf(properties.getProperty("compress-saves", "true")));
            }
            catch (IOException e) {
                SaveMod.LOGGER.error("Could not load config : {}", (Object)e.getMessage());
            }
        }
    }

    public static void save() {
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.createFile(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                SaveMod.LOGGER.error("Could not create config file : {}", (Object)e.getMessage());
            }
        }
        properties.clear();
        properties.setProperty("show-button-on-game-menu", String.valueOf(gameMenu.method_41753()));
        properties.setProperty("show-button-on-world-entries", String.valueOf(worldEntries.method_41753()));
        properties.setProperty("compress-saves", String.valueOf(compression.method_41753()));
        try {
            properties.store(Files.newOutputStream(configPath, new OpenOption[0]), "Configuration file for SaveMod");
        }
        catch (IOException e) {
            SaveMod.LOGGER.error("Could not save config : {}", (Object)e.getMessage());
        }
    }
}

