/*
 * Decompiled with CFR 0.152.
 */
package com.github.rashnain.savemod.gui;

import com.github.rashnain.savemod.SaveMod;
import com.github.rashnain.savemod.gui.NameSaveScreen;
import com.github.rashnain.savemod.gui.widget.SaveListEntry;
import com.github.rashnain.savemod.gui.widget.SaveListWidget;
import com.github.rashnain.savemod.util.ZipUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_4239;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

public class SelectSaveScreen
extends class_437 {
    private class_8132 layout;
    protected final class_437 parent;
    protected final Runnable actionWhenClosed;
    private SaveListWidget saveList;
    private class_342 searchBox;
    private class_4185 loadButton;
    private class_4185 renameButton;
    private class_4185 duplicateButton;
    private class_4185 deleteButton;

    public SelectSaveScreen(class_437 parent) {
        this(parent, null);
    }

    public SelectSaveScreen(class_437 parent, Runnable actionWhenClosed) {
        super((class_2561)class_2561.method_43471((String)"savemod.list.title"));
        this.parent = parent;
        this.actionWhenClosed = actionWhenClosed;
    }

    public boolean method_25404(class_11908 input) {
        if (super.method_25404(input)) {
            return true;
        }
        if (input.method_74229()) {
            this.saveList.getSelectedAsOptional().ifPresent(SaveListEntry::load);
            return true;
        }
        return false;
    }

    protected void method_25426() {
        this.layout = new class_8132((class_437)this, 49, 60);
        class_8667 directionalLayoutWidget = (class_8667)this.layout.method_48992((class_8021)class_8667.method_52741().method_52735(4));
        directionalLayoutWidget.method_52740().method_46467();
        directionalLayoutWidget.method_52736((class_8021)new class_7842(this.field_22785, this.field_22793));
        class_8667 directionalLayoutWidget2 = (class_8667)directionalLayoutWidget.method_52736((class_8021)class_8667.method_52742().method_52735(4));
        this.searchBox = (class_342)directionalLayoutWidget2.method_52736((class_8021)new class_342(this.field_22793, 200, 20, (class_2561)class_2561.method_43473()));
        this.searchBox.method_1863(search -> {
            this.saveList.setSearch((String)search);
            this.changeButtons(this.saveList.method_25334() != null);
        });
        class_7845 gridWidget = (class_7845)this.layout.method_48996((class_8021)new class_7845().method_48635(8).method_48636(4));
        gridWidget.method_46458().method_46467();
        class_7845.class_7939 adder = gridWidget.method_47610(4);
        this.saveList = new SaveListWidget(this, this.field_22787, this.field_22789, this.layout.method_57727(), this.layout.method_48998(), 36);
        this.layout.method_48999((class_8021)this.saveList);
        this.loadButton = (class_4185)adder.method_47613((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"savemod.list.play"), button -> this.saveList.getSelectedAsOptional().ifPresent(SaveListEntry::load)).method_46431(), 2);
        this.loadButton.field_22763 = false;
        adder.method_47613((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"savemod.list.create"), button -> this.field_22787.method_1507((class_437)new NameSaveScreen(this, "", SaveMod.worldDir, this::save))).method_46431(), 2);
        this.renameButton = (class_4185)adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"savemod.list.rename"), button -> this.saveList.getSelectedAsOptional().ifPresent(SaveListEntry::rename)).method_46432(71).method_46431());
        this.renameButton.field_22763 = false;
        this.deleteButton = (class_4185)adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"savemod.list.delete"), button -> this.saveList.getSelectedAsOptional().ifPresent(SaveListEntry::delete)).method_46432(71).method_46431());
        this.deleteButton.field_22763 = false;
        this.duplicateButton = (class_4185)adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"savemod.list.duplicate"), button -> this.saveList.getSelectedAsOptional().ifPresent(SaveListEntry::duplicate)).method_46432(71).method_46431());
        this.duplicateButton.field_22763 = false;
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(71).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.layout.method_48222();
        this.method_48265((class_364)this.searchBox);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
        if (this.actionWhenClosed != null) {
            this.actionWhenClosed.run();
        }
    }

    public void changeButtons(boolean buttonsActive) {
        this.loadButton.field_22763 = buttonsActive;
        this.renameButton.field_22763 = buttonsActive;
        this.duplicateButton.field_22763 = buttonsActive;
        this.deleteButton.field_22763 = buttonsActive;
    }

    public void save(String saveName) {
        this.field_22787.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"savemod.message.saving")));
        if (this.field_22787.method_1496()) {
            this.field_22787.method_1576().method_39218(false, true, false);
        }
        String worldDir = SaveMod.worldDir;
        try {
            Path saveDir;
            DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
            String backupName = LocalDateTime.now().format(TIME_FORMATTER) + "_" + worldDir;
            if (!saveName.isEmpty()) {
                backupName = backupName.substring(0, 20) + saveName;
            }
            if (Files.notExists(saveDir = SaveMod.DIR.resolve(worldDir), new LinkOption[0])) {
                Files.createDirectories(saveDir, new FileAttribute[0]);
            }
            Path backupFileName = saveDir.resolve(class_4239.method_19773((Path)saveDir, (String)backupName, (String)".zip"));
            ZipUtil.createBackup("saves/" + worldDir, backupFileName.toString());
            this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"savemod.toast.succesful"), (class_2561)class_2561.method_43471((String)"savemod.toast.succesful.save")));
            this.saveList.refresh();
            if (this.field_22787.method_1496()) {
                this.field_22787.method_1507(null);
                return;
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"savemod.toast.failed"), (class_2561)class_2561.method_43471((String)"savemod.toast.failed.save")));
            SaveMod.LOGGER.error("Could not save : {}", (Object)e.getMessage());
        }
        this.field_22787.method_1507((class_437)this);
    }
}

