/*
 * Decompiled with CFR 0.152.
 */
package com.github.rashnain.savemod.gui.widget;

import com.github.rashnain.savemod.SaveMod;
import com.github.rashnain.savemod.SaveSummary;
import com.github.rashnain.savemod.gui.NameSaveScreen;
import com.github.rashnain.savemod.gui.widget.SaveListWidget;
import com.github.rashnain.savemod.util.ZipUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_410;
import net.minecraft.class_424;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_8579;

public class SaveListEntry
extends class_4280.class_4281<SaveListEntry> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private static final class_2960 UNKNOWN_SERVER_LOCATION = class_2960.method_60656((String)"textures/misc/unknown_server.png");
    public static final class_2960 JOIN_HIGHLIGHTED_TEXTURE = class_2960.method_60656((String)"world_list/join_highlighted");
    public static final class_2960 JOIN_TEXTURE = class_2960.method_60656((String)"world_list/join");
    private final class_310 client;
    private final SaveListWidget saveList;
    private final SaveSummary save;
    private final Path saveDir;
    private final Path saveFile;
    private long time;

    public SaveListEntry(SaveSummary save, SaveListWidget parent) {
        this.save = save;
        this.saveList = parent;
        this.client = class_310.method_1551();
        this.saveDir = SaveMod.DIR.resolve(save.getWorldDir());
        this.saveFile = this.saveDir.resolve(save.getSaveFileName());
    }

    public class_2561 method_37006() {
        return class_2561.method_30163((String)this.save.getSaveName());
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.comp_4798() - (double)this.saveList.method_25342() <= 32.0) {
            this.load();
            return true;
        }
        if (class_156.method_658() - this.time < 250L) {
            this.load();
            return true;
        }
        this.time = class_156.method_658();
        return true;
    }

    public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
        int x = this.method_73380();
        int y = this.method_73382();
        String displayName = this.save.getSaveName();
        String folderNameAndLastPlayedDate = this.save.getWorldDir() + " (" + DATE_FORMAT.format(new Date(this.save.getLastPlayed())) + ")";
        String fileSize = this.save.getSizeInMB() + " MB";
        context.method_25303(this.client.field_1772, displayName, x + 32 + 3, y + 1, -1);
        class_327 class_3272 = this.client.field_1772;
        Objects.requireNonNull(this.client.field_1772);
        context.method_25303(class_3272, folderNameAndLastPlayedDate, x + 32 + 3, y + 1 + 2 + 9, -8421504);
        class_327 class_3273 = this.client.field_1772;
        Objects.requireNonNull(this.client.field_1772);
        context.method_25303(class_3273, fileSize, x + 32 + 3, y + 1 + (2 + 9) * 2, -8421504);
        context.method_25290(class_10799.field_56883, UNKNOWN_SERVER_LOCATION, x, y, 0.0f, 0.0f, 32, 32, 32, 32);
        if (((Boolean)this.client.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
            context.method_25294(x, y, x + 32, y + 32, -1601138544);
            int pixelsBeforeStartButton = mouseX - x;
            class_2960 texture = pixelsBeforeStartButton <= 32 ? JOIN_HIGHLIGHTED_TEXTURE : JOIN_TEXTURE;
            context.method_52706(class_10799.field_56883, texture, x, y, 32, 32);
        }
    }

    public void load() {
        if (this.client.method_1496()) {
            this.client.field_1687.method_8525((class_2561)class_2561.method_43471((String)"savemod.message.closing"));
            this.client.method_18096((class_437)new class_424((class_2561)class_2561.method_43471((String)"savemod.message.closing")), false);
        }
        this.client.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"savemod.message.deleting")));
        String worldDir = this.save.getWorldDir();
        try (class_32.class_5143 session = this.client.method_1586().method_52236(worldDir);){
            session.method_27015();
            this.client.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"savemod.message.uncompressing")));
            String zipFile = this.saveDir.resolve(this.save.getSaveFileName()).toString();
            try {
                ZipUtil.unzipFile(zipFile, "saves/");
                this.client.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"selectWorld.data_read")));
                this.client.method_41735().method_57784(worldDir, null);
            }
            catch (IOException e) {
                this.client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"savemod.toast.failed"), (class_2561)class_2561.method_43471((String)"savemod.toast.failed.uncompress")));
                SaveMod.LOGGER.error("Could not extract file '{}' : {}", (Object)zipFile, (Object)e);
                this.client.method_1507(this.saveList.getParent());
            }
        }
        catch (IOException | class_8579 e) {
            this.client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"savemod.toast.failed"), (class_2561)class_2561.method_43471((String)"savemod.toast.failed.load")));
            SaveMod.LOGGER.error("Could not delete world '{}' : {}", (Object)worldDir, (Object)e);
            this.client.method_1507(this.saveList.getParent());
        }
    }

    public void rename() {
        this.client.method_1507((class_437)new NameSaveScreen(this.saveList.getParent(), this.save.getSaveName(), this.saveDir.getFileName().toString(), newName -> {
            Object saveFileName = this.saveFile.getFileName().toString();
            if (newName.isEmpty()) {
                newName = this.save.getWorldDir();
            }
            saveFileName = ((String)saveFileName).substring(0, 20) + newName + ".zip";
            try {
                Files.move(this.saveFile, this.saveDir.resolve((String)saveFileName), new CopyOption[0]);
            }
            catch (IOException e) {
                this.client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"savemod.toast.failed"), (class_2561)class_2561.method_43471((String)"savemod.toast.failed.name")));
                SaveMod.LOGGER.error("Could not rename save '{}' : {}", (Object)this.saveFile, (Object)e);
            }
            this.client.method_1507(this.saveList.getParent());
        }));
    }

    public void duplicate() {
        String newSaveName = this.save.getSaveFileName().replaceFirst(".zip$", " " + class_2561.method_43471((String)"savemod.name.copy").getString() + ".zip");
        try {
            Files.copy(this.saveFile, this.saveDir.resolve(newSaveName), new CopyOption[0]);
            this.saveList.refresh();
            this.client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"savemod.toast.succesful"), (class_2561)class_2561.method_43471((String)"savemod.toast.succesful.duplicate")));
        }
        catch (IOException e) {
            this.client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"savemod.toast.failed"), (class_2561)class_2561.method_43471((String)"savemod.toast.failed.duplicate")));
            SaveMod.LOGGER.error("Could not duplicate save '{}' : {}", (Object)this.saveFile, (Object)e);
        }
    }

    public void delete() {
        this.client.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                try {
                    Files.delete(this.saveFile);
                    try {
                        Files.delete(this.saveDir);
                        Files.delete(SaveMod.DIR);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.saveList.removeEntryWithoutScrolling(this);
                }
                catch (IOException e) {
                    this.client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"savemod.toast.failed"), (class_2561)class_2561.method_43471((String)"savemod.toast.failed.delete")));
                    SaveMod.LOGGER.error("Could not delete save '{}' : {}", (Object)this.saveFile, (Object)e);
                }
            }
            this.client.method_1507(this.saveList.getParent());
        }, (class_2561)class_2561.method_43471((String)"savemod.delete.question"), (class_2561)class_2561.method_43469((String)"selectWorld.deleteWarning", (Object[])new Object[]{this.save.getSaveName()})));
    }
}

