/*
 * Decompiled with CFR 0.152.
 */
package com.github.rashnain.savemod.gui.widget;

import com.github.rashnain.savemod.SaveMod;
import com.github.rashnain.savemod.SaveSummary;
import com.github.rashnain.savemod.gui.SelectSaveScreen;
import com.github.rashnain.savemod.gui.widget.SaveListEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class SaveListWidget
extends class_4280<SaveListEntry> {
    private final SelectSaveScreen parent;
    private List<SaveSummary> saves;
    private String search;

    public SaveListWidget(SelectSaveScreen parent, class_310 client, int width, int height, int top, int itemHeight) {
        super(client, width, height, top, itemHeight);
        this.parent = parent;
        this.search = "";
        this.refresh();
    }

    public void setSelected(@Nullable SaveListEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.parent.changeButtons(entry != null);
    }

    public void removeEntryWithoutScrolling(SaveListEntry entry) {
        super.method_44650((class_350.class_351)entry);
    }

    public class_437 getParent() {
        return this.parent;
    }

    public void refresh() {
        this.showSummaries(this.search, this.getSaves());
    }

    private void showSummaries(String search, List<SaveSummary> summaries) {
        this.method_25339();
        this.saves = summaries;
        for (SaveSummary summary : summaries) {
            if (!this.shouldShow(search, summary)) continue;
            this.method_25321((class_350.class_351)new SaveListEntry(summary, this));
        }
    }

    private List<SaveSummary> getSaves() {
        ArrayList<SaveSummary> saveList = new ArrayList<SaveSummary>();
        if (SaveMod.worldDir == null) {
            return saveList;
        }
        File saveDir = SaveMod.DIR.resolve(SaveMod.worldDir).toFile();
        File[] files = saveDir.listFiles(file -> file.isFile() && file.getName().endsWith(".zip") && file.getName().length() > 24);
        if (files != null) {
            Arrays.sort(files, Collections.reverseOrder());
            for (File saveFile : files) {
                SaveSummary saveSummary = new SaveSummary(saveFile.getName(), SaveMod.worldDir, saveFile.length());
                saveList.add(saveSummary);
            }
        }
        return saveList;
    }

    public Optional<SaveListEntry> getSelectedAsOptional() {
        SaveListEntry entry = (SaveListEntry)this.method_25334();
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry);
    }

    public void setSearch(String search) {
        if (!search.equals(this.search)) {
            this.showSummaries(search, this.saves);
            this.search = search;
        }
    }

    private boolean shouldShow(String search, SaveSummary summary) {
        return summary.getSaveName().toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT));
    }
}

