/*
 * Decompiled with CFR 0.152.
 */
package com.github.rashnain.savemod.util;

import com.github.rashnain.savemod.config.SaveModConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.io.FileUtils;

public class ZipUtil {
    public static void unzipFile(String sourceFile, String targetDir) throws IOException {
        byte[] buffer = new byte[65536];
        File previous = null;
        try (ZipFile archive = new ZipFile(sourceFile);){
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File file = new File(targetDir, entry.getName());
                File current = file.getParentFile();
                if (!current.equals(previous)) {
                    if (!current.exists()) {
                        current.mkdirs();
                    }
                    previous = current;
                }
                try (BufferedInputStream in = new BufferedInputStream(archive.getInputStream(entry), 65536);
                     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 65536);){
                    int length;
                    while ((length = ((InputStream)in).read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, length);
                    }
                }
            }
        }
    }

    public static void createBackup(String worldDir, String targetFile) throws IOException, ExecutionException, InterruptedException {
        ParallelScatterZipCreator scatterZipCreator = new ParallelScatterZipCreator();
        try (ZipArchiveOutputStream archive = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(targetFile));){
            File sourceDir = new File(worldDir);
            Iterator fileIterator = FileUtils.iterateFiles((File)sourceDir, null, (boolean)true);
            archive.setUseZip64(Zip64Mode.AsNeeded);
            int sourceDirLength = sourceDir.getParentFile().getAbsolutePath().length() + 1;
            while (fileIterator.hasNext()) {
                File file = (File)fileIterator.next();
                if (file.getName().equals("session.lock")) continue;
                String relativePath = file.getAbsolutePath().substring(sourceDirLength);
                InputStreamSupplier streamSupplier = () -> {
                    try {
                        return new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        return InputStream.nullInputStream();
                    }
                };
                ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(relativePath);
                if (((Boolean)SaveModConfig.compression.method_41753()).booleanValue()) {
                    zipArchiveEntry.setMethod(8);
                } else {
                    zipArchiveEntry.setMethod(0);
                }
                scatterZipCreator.addArchiveEntry(zipArchiveEntry, streamSupplier);
            }
            scatterZipCreator.writeTo(archive);
        }
    }
}

