/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.misinput;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.notcharrow.misinput.config.ConfigManager;
import com.notcharrow.misinput.helper.SuggestionBuilder;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class Misinput
implements ModInitializer {
    private static final class_310 client = class_310.method_1551();

    public void onInitialize() {
        ConfigManager.loadConfig();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"misinput").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).executes(Misinput::addUsername)))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests(SuggestionBuilder.createSuggestionProvider(ConfigManager.config.usernames)).executes(Misinput::removeUsername)))).then(ClientCommandManager.literal((String)"list").executes(Misinput::listUsernames))));
    }

    private static int addUsername(CommandContext<FabricClientCommandSource> context) {
        String username = StringArgumentType.getString(context, (String)"username");
        ConfigManager.config.usernames.add(username.toLowerCase());
        ConfigManager.saveConfig();
        if (Misinput.client.field_1724 != null) {
            Misinput.client.field_1724.method_7353(class_2561.method_30163((String)("Username: " + username + " added.")), false);
        }
        return 1;
    }

    private static int removeUsername(CommandContext<FabricClientCommandSource> context) {
        String username = StringArgumentType.getString(context, (String)"username");
        ConfigManager.config.usernames.remove(username.toLowerCase());
        ConfigManager.saveConfig();
        if (Misinput.client.field_1724 != null) {
            Misinput.client.field_1724.method_7353(class_2561.method_30163((String)("Username: " + username + " removed.")), false);
        }
        return 1;
    }

    private static int listUsernames(CommandContext<FabricClientCommandSource> context) {
        List<String> usernames = ConfigManager.config.usernames;
        Collections.sort(usernames);
        StringBuilder output = new StringBuilder("Usernames: ");
        for (String username : usernames) {
            if (usernames.indexOf(username) == usernames.size() - 1) {
                output.append(username);
                continue;
            }
            output.append(username).append(", ");
        }
        if (Misinput.client.field_1724 != null) {
            Misinput.client.field_1724.method_7353(class_2561.method_30163((String)String.valueOf(output)), false);
        }
        return 1;
    }
}

