/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.misinput.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.notcharrow.misinput.config.MisinputConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config", "misinput.json");
    public static MisinputConfig config;

    public static void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            config = new MisinputConfig();
            ConfigManager.saveConfig();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            config = (MisinputConfig)GSON.fromJson((Reader)reader, MisinputConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            config = new MisinputConfig();
        }
    }

    public static void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

