/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.block;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rk.thingamajigs.block.custom.blocks.ToggledStateBlock;
import net.rk.thingamajigs.particle.ThingamajigsParticles;

public class SnowMachine
extends ToggledStateBlock {
    public static final VoxelShape NORTH_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)8.0, (double)13.0), Block.m_49796_((double)1.0, (double)5.0, (double)7.0, (double)3.0, (double)13.0, (double)9.0), Block.m_49796_((double)13.0, (double)5.0, (double)7.0, (double)15.0, (double)13.0, (double)9.0), Block.m_49796_((double)3.0, (double)5.0, (double)13.0, (double)13.0, (double)16.0, (double)17.0), Block.m_49796_((double)3.0, (double)7.0, (double)9.0, (double)13.0, (double)18.0, (double)13.0), Block.m_49796_((double)3.0, (double)9.0, (double)5.0, (double)13.0, (double)20.0, (double)9.0), Block.m_49796_((double)3.0, (double)11.0, (double)1.0, (double)13.0, (double)22.0, (double)5.0), Block.m_49796_((double)3.0, (double)9.0, (double)-5.0, (double)13.0, (double)23.0, (double)1.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SOUTH_SHAPE = Stream.of(Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)2.0, (double)5.0, (double)3.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)13.0, (double)5.0, (double)7.0, (double)15.0, (double)13.0, (double)9.0), Block.m_49796_((double)1.0, (double)5.0, (double)7.0, (double)3.0, (double)13.0, (double)9.0), Block.m_49796_((double)3.0, (double)5.0, (double)-1.0, (double)13.0, (double)16.0, (double)3.0), Block.m_49796_((double)3.0, (double)7.0, (double)3.0, (double)13.0, (double)18.0, (double)7.0), Block.m_49796_((double)3.0, (double)9.0, (double)7.0, (double)13.0, (double)20.0, (double)11.0), Block.m_49796_((double)3.0, (double)11.0, (double)11.0, (double)13.0, (double)22.0, (double)15.0), Block.m_49796_((double)3.0, (double)9.0, (double)15.0, (double)13.0, (double)23.0, (double)21.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape EAST_SHAPE = Stream.of(Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)3.0, (double)5.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)7.0, (double)5.0, (double)1.0, (double)9.0, (double)13.0, (double)3.0), Block.m_49796_((double)7.0, (double)5.0, (double)13.0, (double)9.0, (double)13.0, (double)15.0), Block.m_49796_((double)-1.0, (double)5.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), Block.m_49796_((double)3.0, (double)7.0, (double)3.0, (double)7.0, (double)18.0, (double)13.0), Block.m_49796_((double)7.0, (double)9.0, (double)3.0, (double)11.0, (double)20.0, (double)13.0), Block.m_49796_((double)11.0, (double)11.0, (double)3.0, (double)15.0, (double)22.0, (double)13.0), Block.m_49796_((double)15.0, (double)9.0, (double)3.0, (double)21.0, (double)23.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape WEST_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)2.0, (double)5.0, (double)2.0, (double)13.0, (double)8.0, (double)14.0), Block.m_49796_((double)7.0, (double)5.0, (double)13.0, (double)9.0, (double)13.0, (double)15.0), Block.m_49796_((double)7.0, (double)5.0, (double)1.0, (double)9.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)5.0, (double)3.0, (double)17.0, (double)16.0, (double)13.0), Block.m_49796_((double)9.0, (double)7.0, (double)3.0, (double)13.0, (double)18.0, (double)13.0), Block.m_49796_((double)5.0, (double)9.0, (double)3.0, (double)9.0, (double)20.0, (double)13.0), Block.m_49796_((double)1.0, (double)11.0, (double)3.0, (double)5.0, (double)22.0, (double)13.0), Block.m_49796_((double)-5.0, (double)9.0, (double)3.0, (double)1.0, (double)23.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public SnowMachine(BlockBehaviour.Properties p) {
        super(p.m_60913_(1.0f, 10.0f).m_60918_(SoundType.f_56762_).m_284180_(MapColor.f_283818_));
        ((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TOGGLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)TOGGLED)).booleanValue()) {
            double posX = (double)pos.m_123341_() + 0.5;
            double posY = (double)pos.m_123342_() + 1.25;
            double posZ = (double)pos.m_123343_() + 0.5;
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            Direction.Axis axis = direction.m_122434_();
            double d3 = 0.52;
            double d4 = random.m_188500_() * 0.6 - 0.3;
            double d5 = axis == Direction.Axis.X ? (double)direction.m_122429_() * d3 : d4;
            double d7 = axis == Direction.Axis.Z ? (double)direction.m_122431_() * d3 : d4;
            double x1 = posX + d5;
            double x = 0.0;
            double z = 0.0;
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case NORTH: {
                    x = 0.0;
                    z = -0.151;
                    break;
                }
                case EAST: {
                    x = 0.151;
                    z = 0.0;
                    break;
                }
                case WEST: {
                    x = -0.151;
                    z = 0.0;
                    break;
                }
                case SOUTH: {
                    x = 0.0;
                    z = 0.151;
                }
            }
            level.m_7106_((ParticleOptions)ThingamajigsParticles.ICY_AIR.get(), posX + d5, posY, posZ + d7, x, 0.175, z);
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_144203_, SoundSource.BLOCKS, 0.25f, 1.0f - level.m_213780_().m_188501_() * 0.5f, true);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return Shapes.m_83144_();
    }
}

