/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.block.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlantRoadSign
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final int MIN_TYPES = 0;
    public static final int MAX_TYPES = 9;
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)9);
    public static final VoxelShape SIGN_SHAPE_SIDE = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape SIGN_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)8.0);

    public PlantRoadSign(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(0.25f).m_60918_(SoundType.f_56762_).m_60955_().m_60910_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TYPE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        switch (direction) {
            case NORTH: {
                return SIGN_SHAPE;
            }
            case SOUTH: {
                return SIGN_SHAPE;
            }
            case EAST: {
                return SIGN_SHAPE_SIDE;
            }
            case WEST: {
                return SIGN_SHAPE_SIDE;
            }
        }
        return SIGN_SHAPE;
    }

    public void m_5871_(ItemStack p_49816_, @Nullable BlockGetter p_49817_, List<Component> p_49818_, TooltipFlag p_49819_) {
        p_49818_.add((Component)Component.m_237115_((String)"tooltip.thingamajigs.plant_road_sign"));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            if (pHand == InteractionHand.MAIN_HAND && pPlayer.m_6144_()) {
                int tv_type = (Integer)pState.m_61143_((Property)TYPE);
                double d0 = (double)pPos.m_123341_() + 0.5;
                double d1 = (double)pPos.m_123342_() + 0.5;
                double d2 = (double)pPos.m_123343_() + 0.5;
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(++tv_type)), 0);
                if (tv_type >= 9) {
                    tv_type = 0;
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(tv_type)), 0);
                }
                PlantRoadSign.playSound((LevelAccessor)pLevel, d0, d1, d2);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public static void playSound(LevelAccessor world, double x, double y, double z) {
        if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.m_5776_()) {
                _level.m_5594_(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.f_12017_, SoundSource.BLOCKS, 10.0f, 1.0f);
            } else {
                _level.m_7785_(x, y, z, SoundEvents.f_12017_, SoundSource.BLOCKS, 10.0f, 1.0f, false);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }
}

