/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.block.custom.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.rk.thingamajigs.entity.MailboxBlockEntity;
import net.rk.thingamajigs.item.ThingamajigsItems;
import org.jetbrains.annotations.Nullable;

public class BasicMailbox
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LOCKED = BooleanProperty.m_61465_((String)"locked");
    public static final VoxelShape NORTHSOUTH_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Block.m_49796_((double)5.0, (double)13.0, (double)1.0, (double)11.0, (double)19.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape EASTWEST_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)5.0, (double)15.0, (double)19.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);

    public BasicMailbox(BlockBehaviour.Properties properties) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50087_).m_60918_(SoundType.f_56762_).m_60913_(2.0f, 32.0f).m_60999_().m_60955_().m_60977_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidstate) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, LOCKED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Item item = player.m_150109_().m_36056_().m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return tieredItem.m_43314_().m_6604_() >= 0;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                return NORTHSOUTH_SHAPE;
            }
            case EAST: 
            case WEST: {
                return EASTWEST_SHAPE;
            }
        }
        return Shapes.m_83144_();
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(blockPos)) instanceof MailboxBlockEntity) {
            Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((MailboxBlockEntity)blockEntity));
        }
        super.m_6810_(state, level, blockPos, newState, isMoving);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.m_5776_()) return InteractionResult.m_19078_((boolean)level.f_46443_);
        if (player.m_21120_(hand).m_150930_((Item)ThingamajigsItems.KEY.get())) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61122_((Property)LOCKED), 3);
            if (((Boolean)blockState.m_61143_((Property)LOCKED)).booleanValue()) {
                level.m_5594_(null, blockPos, SoundEvents.f_11672_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            } else {
                level.m_5594_(null, blockPos, SoundEvents.f_11679_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        } else if (!((Boolean)blockState.m_61143_((Property)LOCKED)).booleanValue()) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (!(blockEntity instanceof MailboxBlockEntity)) throw new IllegalStateException("MailboxBlockEntity Container Provider is missing!");
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MailboxBlockEntity)blockEntity), (BlockPos)blockPos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        } else {
            level.m_5594_(null, blockPos, SoundEvents.f_11748_, SoundSource.BLOCKS, 0.75f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"message.thingamajigs.generic.locked"), true);
            return InteractionResult.PASS;
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos bpe1, BlockState bse1) {
        return new MailboxBlockEntity(bpe1, bse1);
    }
}

