/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.block.custom.blocks;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rk.thingamajigs.events.ThingamajigsSoundEvents;

public class Doorbell
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)5.0, (double)4.0, (double)10.0, (double)11.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)6.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)10.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)11.0);
    private SoundEvent bellSound = (SoundEvent)ThingamajigsSoundEvents.ELECTRONIC.get();

    public Doorbell(BlockBehaviour.Properties properties) {
        super(properties.m_60955_().m_60910_().m_60978_(1.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public Doorbell(SoundEvent doorbellSound, BlockBehaviour.Properties properties) {
        super(properties.m_60955_().m_60910_().m_60978_(1.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.bellSound = doorbellSound;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        switch (direction) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return Shapes.m_83144_();
    }

    private int getPressDuration() {
        return 30;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int max = 4;
        int min = 1;
        Random rand = new Random();
        int rN = rand.nextInt(max - min + 1) + min;
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.press(pState, pLevel, pPos);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_223702_, pPos);
        pLevel.m_7785_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), this.bellSound, SoundSource.BLOCKS, 100.0f, 1.0f, false);
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.m_60713_(pNewState.m_60734_())) {
            if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
                this.updateNeighbours(pState, pLevel, pPos);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandomSource) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            this.updateNeighbours(pState, (Level)pLevel, pPos);
            pLevel.m_142346_(null, GameEvent.f_223703_, pPos);
        }
    }

    public void press(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(pState, pLevel, pPos);
        pLevel.m_7785_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_12067_, SoundSource.BLOCKS, 100.0f, 1.0f, false);
        pLevel.m_186460_(pPos, (Block)this, this.getPressDuration());
    }

    private void updateNeighbours(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46672_(pPos, (Block)this);
        pLevel.m_46672_(pPos.m_122012_(), (Block)this);
        pLevel.m_46672_(pPos.m_122019_(), (Block)this);
        pLevel.m_46672_(pPos.m_122029_(), (Block)this);
        pLevel.m_46672_(pPos.m_122024_(), (Block)this);
        pLevel.m_46672_(pPos.m_7494_(), (Block)this);
        pLevel.m_46672_(pPos.m_7495_(), (Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, POWERED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }
}

