/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ThingamajigsServerConfigs {
    public static final ForgeConfigSpec CPSEC;
    public static final ThingamajigsCommon COMMON;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(ThingamajigsCommon::new);
        CPSEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (ThingamajigsCommon)commonSpecPair.getLeft();
    }

    public static class ThingamajigsCommon {
        public final ForgeConfigSpec.BooleanValue opBlocksEnabled;
        public final ForgeConfigSpec.IntValue maxThingamajigsStackSize;
        public final ForgeConfigSpec.IntValue mechanicalBellSpeed;
        public final ForgeConfigSpec.IntValue electronicBellSpeed;
        public final ForgeConfigSpec.IntValue britAlarmSpeed;
        public final ForgeConfigSpec.BooleanValue moneyExchangeEnabled;

        ThingamajigsCommon(ForgeConfigSpec.Builder builder) {
            builder.comment(" Thingamajigs Common Config");
            builder.comment(" These settings affect both server and client. Some settings will require a world or game restart.");
            builder.comment(" Be careful to read each config option carefully (joining to server allows the server to override these settings with it's own).");
            builder.comment(" Special Map Builder Blocks In Creative Tab");
            this.opBlocksEnabled = builder.comment(" Enables or disables the special map maker blocks in the OP Blocks creative tab. (default: false)").comment(" Note: You need operator permissions to actually see the blocks in the creative tab.").define("opBlocksEnabled", false);
            builder.comment(" Max Stack Size For Thingamajig");
            this.maxThingamajigsStackSize = builder.comment(" Sets the max stack size of the Thingamajig item.").comment(" Note: Requires a world restart.").defineInRange("maxThingamajigsStackSize", 64, 16, 64);
            builder.comment(" Mechanical Bells Tick Speed");
            this.mechanicalBellSpeed = builder.comment(" Sets the tick speed of Mechanical Bells").comment(" Warning: Setting this low will make it ring faster, but tick more often.").defineInRange("mechanicalBellSpeed", 10, 8, 16);
            builder.comment(" Electronic Bells Tick Speed");
            this.electronicBellSpeed = builder.comment(" Sets the tick speed of Electronic Bells").comment(" Warning: Setting this low will make it ring faster, but tick more often.").defineInRange("electronicBellSpeed", 8, 8, 16);
            builder.comment(" British Alarm Tick Speed");
            this.britAlarmSpeed = builder.comment(" Sets the tick speed of Railway Alarms").comment(" Warning: Setting this low will make it sound faster, but tick more often.").defineInRange("britAlarmSpeed", 10, 8, 16);
            builder.comment(" Money Exchanging");
            this.moneyExchangeEnabled = builder.comment(" Enables the money exchanging mechanic. Basically makes the change machine useful or not.").define("moneyExchangeEnabled", false);
        }
    }
}

