/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.rk.thingamajigs.datagen.ThingamajigsBiomeTags;
import net.rk.thingamajigs.datagen.ThingamajigsBlockModelProvider;
import net.rk.thingamajigs.datagen.ThingamajigsBlockStateProvider;
import net.rk.thingamajigs.datagen.ThingamajigsBlockTagProvider;
import net.rk.thingamajigs.datagen.ThingamajigsFluidTagProvider;
import net.rk.thingamajigs.datagen.ThingamajigsItemModelProvider;
import net.rk.thingamajigs.datagen.ThingamajigsItemTagProvider;
import net.rk.thingamajigs.datagen.ThingamajigsLootTables;
import net.rk.thingamajigs.datagen.ThingamajigsRecipeProvider;
import net.rk.thingamajigs.datagen.ThingamajigsWorldGenProvider;

@Mod.EventBusSubscriber(modid="thingamajigs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ThingamajigsRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ThingamajigsLootTables::new, LootContextParamSets.f_81421_))));
        generator.addProvider(event.includeClient(), (DataProvider)new ThingamajigsBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ThingamajigsBlockModelProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ThingamajigsItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ThingamajigsFluidTagProvider(packOutput, lookupProvider, "thingamajigs", existingFileHelper));
        ThingamajigsBlockTagProvider blockTagGenerator = (ThingamajigsBlockTagProvider)generator.addProvider(true, (DataProvider)new ThingamajigsBlockTagProvider(packOutput, lookupProvider, "thingamajigs", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ThingamajigsItemTagProvider(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ThingamajigsBiomeTags(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ThingamajigsWorldGenProvider(packOutput, lookupProvider));
    }
}

