/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.rk.thingamajigs.block.ThingamajigsBlocks;
import org.jetbrains.annotations.NotNull;

public class ThingamajigsBlockModelProvider
extends BlockModelProvider {
    public static final ResourceLocation POLE_TEXTURE = new ResourceLocation("minecraft:block/blast_furnace_side");

    public ThingamajigsBlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "thingamajigs", existingFileHelper);
    }

    protected void registerModels() {
        this.signModelBuilder(ThingamajigsBlocks.CANADIAN_CROSSBUCK, "symbol_signs", "canadian_crossbuck", "back_rr_crossing");
        this.signModelBuilder(ThingamajigsBlocks.JAPAN_CROSSBUCK, "international", "japan_rrc", "international/back_jrrc");
        this.signModelBuilder(ThingamajigsBlocks.CATEYE_CROSSBUCK, "text_signs", "cateye_railroad_crossing", "back_rr_crossing");
        this.signModelBuilder(ThingamajigsBlocks.INVERTED_CATEYE_CROSSBUCK, "text_signs", "inverted_cateye_railroad_crossing", "back_rr_crossing");
        this.standingTorchModelBuilder(ThingamajigsBlocks.RED_LANTERN, "thingamajigs:block/torches/red_lantern");
        this.wallTorchModelBuilder(ThingamajigsBlocks.WALL_RED_LANTERN, "thingamajigs:block/torches/red_lantern");
        this.standingTorchModelBuilder(ThingamajigsBlocks.PAPER_LANTERN, "thingamajigs:block/torches/paper_lantern");
        this.wallTorchModelBuilder(ThingamajigsBlocks.WALL_PAPER_LANTERN, "thingamajigs:block/torches/paper_lantern");
        this.lanternModelBuilder(ThingamajigsBlocks.SCULK_LANTERN, "thingamajigs:block/lanterns/sculk_lantern");
        this.hangingLanternModelBuilder(ThingamajigsBlocks.SCULK_LANTERN, "thingamajigs:block/lanterns/sculk_lantern");
        this.customChainModelBuilder(ThingamajigsBlocks.SCULK_CHAIN, "thingamajigs:block/chains/sculk_chain");
        this.allSidedBlock(ThingamajigsBlocks.SPOOKY_STONE, "thingamajigs:block/stone/spooky_stone");
        this.allSidedBlock(ThingamajigsBlocks.BLUEBERRY_STONE, "thingamajigs:block/stone/blueberry_stone");
        this.allSidedBlock(ThingamajigsBlocks.NETHERISH_STONE, "thingamajigs:block/stone/netherish_stone");
        this.allSidedBlock(ThingamajigsBlocks.VOLCANIC_STONE, "thingamajigs:block/stone/volcanic_stone");
        this.allSidedBlock(ThingamajigsBlocks.CHARGED_VOLCANIC_STONE, "thingamajigs:block/stone/charged_volcanic_stone");
        this.signModelBuilder(ThingamajigsBlocks.ASCENT, "uk_signs/triangle", "ascent", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.DESCENT, "uk_signs/triangle", "descent", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.CHILDREN, "uk_signs/triangle", "children", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.CROSSING_NO_GATES, "uk_signs/triangle", "crossing_no_gates", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.DANGER, "uk_signs/triangle", "danger", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.DUAL_ENDS, "uk_signs/triangle", "dual_ends", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.ELDER, "uk_signs/triangle", "elder", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.GATED_CROSSING, "uk_signs/triangle", "gated_crossing", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.GIVE_WAY, "uk_signs/triangle", "giveway", "back_uk_inverted_triangle");
        this.signModelBuilder(ThingamajigsBlocks.HUMP_BRIDGE, "uk_signs/triangle", "hump_bridge", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.MINECARTS, "uk_signs/triangle", "minecarts", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.NARROW_BOTH, "uk_signs/triangle", "narrow_both", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.OPEN_BRIDGE, "uk_signs/triangle", "open_bridge", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.PEDS_AHEAD, "uk_signs/triangle", "peds_ahead", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.RIVERBANK, "uk_signs/triangle", "riverbank", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.ROAD_WORK, "uk_signs/triangle", "road_work", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.ROUNDABOUT_UK, "uk_signs/triangle", "roundabout", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.SIDE_WIND, "uk_signs/triangle", "side_wind", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.SIGNAL_AHEAD, "uk_signs/triangle", "signal_ahead", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.SLIPPERY, "uk_signs/triangle", "slippery", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.SOFT_VERGE, "uk_signs/triangle", "soft_verge", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.STOP_OR_GIVEWAY_AHEAD, "uk_signs/triangle", "stop_or_giveway_ahead", "back_uk_inverted_triangle");
        this.signModelBuilder(ThingamajigsBlocks.TRY, "uk_signs/triangle", "try", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.TUNNEL, "uk_signs/triangle", "tunnel", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.UNEVEN, "uk_signs/triangle", "uneven", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.WATER_COURSE, "uk_signs/triangle", "water_course", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.ZEBRA, "uk_signs/triangle", "zebra", "back_uk_triangle");
        this.signModelBuilder(ThingamajigsBlocks.ALL_PROHIBITED, "uk_signs/circle", "all_vehicles_prohibited", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.HORSE_PROHIBITED, "uk_signs/circle", "horse_prohibited", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.MOTOR_VEHICLES_PROHIBITED, "uk_signs/circle", "motor_vehicles_prohibited", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.MOTORCYCLES_PROHIBITED, "uk_signs/circle", "motorcycles_prohibited", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.NO_OVERTAKING, "uk_signs/circle", "no_overtaking", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.NO_STOPPING, "uk_signs/circle", "no_stopping", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.NO_WAITING, "uk_signs/circle", "no_waiting", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.PEDS_PROHIBITED, "uk_signs/circle", "peds_prohibited", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.SPEED_50, "uk_signs/circle", "speed_50", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.SPEED_40, "uk_signs/circle", "speed_40", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.SPEED_30, "uk_signs/circle", "speed_30", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.SPEED_20, "uk_signs/circle", "speed_20", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.SPEED_10, "uk_signs/circle", "speed_10", "back_circle");
        this.signModelBuilder(ThingamajigsBlocks.CATTLE_GRID, "uk_signs/triangle", "cattle_grid", "back_uk_triangle");
        this.allSidedBlock(ThingamajigsBlocks.CRYSTAL_BLOCK, "thingamajigs:block/crystal");
        this.allSidedBlock(ThingamajigsBlocks.CIRCUITS, "thingamajigs:block/circuit_board_texture");
        this.allSidedBlock(ThingamajigsBlocks.MYSTERIOUS_ONE_WOOL, "thingamajigs:block/mysterious_one_wool");
        this.signModelBuilder(ThingamajigsBlocks.GRID_SIGN, "text_signs", "grid", "back_diamond");
        this.signModelBuilder(ThingamajigsBlocks.WRONG_WAY, "text_signs", "wrong_way", "back_slightly_bigger_rectangle");
        this.allSidedBlock(ThingamajigsBlocks.CONCRETE, "thingamajigs:block/concrete");
        this.allSidedBlock(ThingamajigsBlocks.CONCRETE_BRICKS, "thingamajigs:block/concrete_bricks");
        this.allSidedBlock(ThingamajigsBlocks.COBBLED_CONCRETE, "thingamajigs:block/cobbled_concrete");
        this.signModelBuilder(ThingamajigsBlocks.NO_LEFT_TURN, "symbol_signs", "no_left_turn", "back");
        this.signModelBuilder(ThingamajigsBlocks.NO_RIGHT_TURN, "symbol_signs", "no_right_turn", "back");
        this.signModelBuilder(ThingamajigsBlocks.NO_STRAIGHT, "symbol_signs", "no_straight", "back");
        this.signModelBuilder(ThingamajigsBlocks.NO_U_TURN, "symbol_signs", "no_u_turn", "back");
        this.signModelBuilder(ThingamajigsBlocks.DO_NOT_ENTER, "text_signs", "do_not_enter", "back");
        this.signModelBuilder(ThingamajigsBlocks.HAZARDOUS_MATERIALS, "text_signs", "hazardous_materials", "back");
        this.signModelBuilder(ThingamajigsBlocks.NO_HAZARDOUS_MATERIALS, "text_signs", "no_hazardous_materials", "back");
        this.signModelBuilder(ThingamajigsBlocks.ONLY_LEFT, "text_signs", "only_left", "back_special_vertical_rectangle");
        this.signModelBuilder(ThingamajigsBlocks.ONLY_RIGHT, "text_signs", "only_right", "back_special_vertical_rectangle");
        this.signModelBuilder(ThingamajigsBlocks.ONLY_UP, "text_signs", "only_up", "back_special_vertical_rectangle");
        this.signModelBuilder(ThingamajigsBlocks.HOV_ONLY, "text_signs", "hov_only", "back_special_vertical_rectangle");
        this.signModelBuilder(ThingamajigsBlocks.HOV_ENDS, "text_signs", "hov_ends", "back_special_vertical_rectangle");
        this.allSidedBlock(ThingamajigsBlocks.OUTLET_BLOCK, "thingamajigs:block/factory/outlet");
        this.allSidedBlock(ThingamajigsBlocks.PAPER_WALL_BLOCK, "thingamajigs:block/paper/plain");
        this.allSidedBlock(ThingamajigsBlocks.PAPER_FLOWER_WALL_BLOCK, "thingamajigs:block/paper/flower");
        this.signModelBuilder(ThingamajigsBlocks.ORANGE_PRIVATE_PROPERTY_SIGN, "text_signs", "orange_private_property", "back_slightly_bigger_rectangle");
        this.signModelBuilder(ThingamajigsBlocks.VIDEO_IN_PROGRESS_SIGN, "text_signs", "video_in_progress", "back_slightly_bigger_rectangle");
        this.signModelBuilder(ThingamajigsBlocks.NO_STARING_PRIVATE_PROPERTY_SIGN, "text_signs", "no_staring_private_property", "back_slightly_bigger_rectangle");
    }

    private BlockModelBuilder cakeBlock(RegistryObject<Block> block, String cakeBottom, String cakeTop, String cakeSide) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("minecraft:block/cake"))).texture("bottom", new ResourceLocation(cakeBottom))).texture("top", new ResourceLocation(cakeTop))).texture("side", new ResourceLocation(cakeSide))).texture("particle", new ResourceLocation("side"));
    }

    public BlockModelBuilder rotatedSlabBottom(RegistryObject<Block> block, String marking, String age) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("thingamajigs:block/bases/base_marked_asphalt_slab_bottom"))).texture("marking", new ResourceLocation(marking))).texture("age", new ResourceLocation(age));
    }

    public BlockModelBuilder rotatedSlabTop(RegistryObject<Block> block, String marking, String age) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("thingamajigs:block/bases/base_marked_asphalt_slab_top"))).texture("marking", new ResourceLocation(marking))).texture("age", new ResourceLocation(age));
    }

    private BlockModelBuilder orientableBlock(RegistryObject<Block> block, String front, String side, String top) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("minecraft:block/orientable"))).texture("front", new ResourceLocation(front))).texture("side", new ResourceLocation(side))).texture("top", new ResourceLocation(top));
    }

    private BlockModelBuilder cubeColumnBlock(RegistryObject<Block> block, String end, String side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("minecraft:cube_column"))).texture("end", new ResourceLocation(end))).texture("side", new ResourceLocation(side));
    }

    private BlockModelBuilder customPumpkinBlock(RegistryObject<Block> block, String end, String side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("thingamajigs:bases/custom_pumpkin"))).texture("end", new ResourceLocation(end))).texture("side", new ResourceLocation(side));
    }

    private BlockModelBuilder allSidedBlock(RegistryObject<Block> block, String textureLocation) {
        return (BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("minecraft:block/cube_all"))).texture("all", new ResourceLocation(textureLocation));
    }

    @NotNull
    private BlockModelBuilder signModelBuilder(RegistryObject<Block> block, String directory, String front, String back) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("thingamajigs:bases/sign"))).texture("front", new ResourceLocation("thingamajigs:block/signs/" + directory + "/" + front))).texture("back", new ResourceLocation("thingamajigs:block/signs/back/" + back))).texture("pole", POLE_TEXTURE)).texture("particle", POLE_TEXTURE);
    }

    private BlockModelBuilder standingTorchModelBuilder(RegistryObject<Block> block, String directory) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("thingamajigs:bases/standing_torch"))).texture("0", new ResourceLocation(directory))).texture("particle", new ResourceLocation(directory))).renderType("cutout");
    }

    private BlockModelBuilder wallTorchModelBuilder(RegistryObject<Block> block, String directory) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("thingamajigs:bases/wall_torch"))).texture("0", new ResourceLocation(directory))).texture("missing", new ResourceLocation(directory))).texture("particle", new ResourceLocation(directory))).renderType("cutout");
    }

    private BlockModelBuilder lanternModelBuilder(RegistryObject<Block> block, String directory) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("minecraft:block/template_lantern"))).texture("lantern", directory)).renderType("cutout");
    }

    private BlockModelBuilder hangingLanternModelBuilder(RegistryObject<Block> block, String directory) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_() + "_hanging", new ResourceLocation("minecraft:block/template_hanging_lantern"))).texture("lantern", directory)).renderType("cutout");
    }

    private BlockModelBuilder customChainModelBuilder(RegistryObject<Block> block, String textureDirectory) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("minecraft:block/chain"))).texture("all", textureDirectory)).texture("particle", textureDirectory)).renderType("cutout");
    }
}

