/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.rk.thingamajigs.block.ThingamajigsBlocks;
import net.rk.thingamajigs.entity.ThingamajigsEntities;
import net.rk.thingamajigs.item.ThingamajigsItems;

public class InfiMoveCart
extends AbstractMinecart {
    private static final EntityDataAccessor<Boolean> FUELED = SynchedEntityData.m_135353_(InfiMoveCart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int fuel;
    private final int maxFuel = Short.MAX_VALUE;
    public double xPush;
    public double zPush;
    public double lerpedYaw = 0.0;
    private static final Ingredient INGREDIENTS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42200_, Items.f_42413_, Items.f_42414_, Items.f_42398_, Items.f_42420_, Items.f_42423_, Items.f_42422_, Items.f_42421_, Items.f_42424_});

    protected InfiMoveCart(EntityType<?> et, Level lvl) {
        super(et, lvl);
        this.setDragAir(2.2);
        this.setMaxSpeedAirLateral(0.8f);
        this.setMaxSpeedAirVertical(-1.2f);
    }

    protected InfiMoveCart(EntityType<?> et2, Level l2, double xo1, double yo1, double zo1) {
        super(et2, l2, xo1, yo1, zo1);
        this.setDragAir(2.2);
        this.setMaxSpeedAirLateral(0.8f);
        this.setMaxSpeedAirVertical(-1.2f);
    }

    public InfiMoveCart(Level level1, double d0, double d1, double d2) {
        super((EntityType)ThingamajigsEntities.INFIMOVE_MINECART.get(), level1, d0, d1, d2);
        this.setDragAir(2.2);
        this.setMaxSpeedAirLateral(0.8f);
        this.setMaxSpeedAirVertical(-1.2f);
    }

    protected Item m_213728_() {
        Item item = (Item)ThingamajigsItems.INFIMOVE_MINECART_ITEM.get();
        return item;
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.FURNACE;
    }

    public void m_8119_() {
        double oldYaw = this.f_19859_;
        super.m_8119_();
        BlockState bsAbove = this.m_9236_().m_8055_(this.m_20183_().m_7494_());
        BlockState bsBelow = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        BlockState rail = this.m_9236_().m_8055_(this.m_20183_());
        if (bsAbove.m_60713_(Blocks.f_50504_) || bsAbove.m_60713_(Blocks.f_50108_)) {
            this.fuel = 0;
        } else if (bsAbove.m_60713_(Blocks.f_50495_) || bsAbove.m_60713_(Blocks.f_50503_) || bsAbove.m_60713_(Blocks.f_50099_) || bsAbove.m_60713_(Blocks.f_50107_)) {
            this.fuel = Short.MAX_VALUE;
            this.setHasFuel(true);
            if (this.m_20184_().f_82479_ <= 0.0) {
                this.xPush = 1.0;
            }
            if (this.m_20184_().f_82481_ <= 0.0) {
                this.zPush = 1.0;
            }
        } else if (bsBelow.m_60713_(Blocks.f_50495_) || bsBelow.m_60713_(Blocks.f_50503_) || bsBelow.m_60713_(Blocks.f_50099_) || bsBelow.m_60713_(Blocks.f_50107_)) {
            this.fuel = Short.MAX_VALUE;
            this.setHasFuel(true);
            if (this.m_20184_().f_82479_ >= -1.0E-5) {
                this.xPush = 1.0;
            }
            if (this.m_20184_().f_82481_ >= -1.0E-5) {
                this.zPush = 1.0;
            }
        } else if (rail.m_60713_(Blocks.f_50016_) || !(rail.m_60734_() instanceof BaseRailBlock)) {
            // empty if block
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.fuel > this.maxFuel) {
                this.fuel = this.maxFuel;
            }
            if (this.fuel <= 0) {
                this.xPush = 0.0;
                this.zPush = 0.0;
            }
            this.setHasFuel(this.fuel > 0);
            if (this.m_20184_().f_82480_ > 0.0 || this.m_20184_().f_82480_ < 0.0) {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ / 1.5, this.m_20184_().f_82481_);
            }
        }
        if (rail.m_60734_() instanceof BaseRailBlock && this.hasFuel()) {
            if (this.f_19797_ % 4 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 0.0, 0.0, 0.0);
            } else if (this.f_19797_ % 200 == 0) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11715_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        this.lerpedYaw = Mth.m_14139_((double)this.f_19797_, (double)this.f_19859_, (double)oldYaw);
        this.f_19859_ = (float)this.lerpedYaw;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUELED, (Object)false);
    }

    public ItemStack m_142340_() {
        Item item = (Item)ThingamajigsItems.INFIMOVE_MINECART_ITEM.get();
        return new ItemStack((ItemLike)item);
    }

    protected double m_7097_() {
        return (this.m_20069_() ? 4.0 : 8.0) / 20.0;
    }

    protected void m_6401_(BlockPos bp, BlockState bs) {
        double d0 = 1.0E-4;
        double d1 = 0.001;
        super.m_6401_(bp, bs);
        Vec3 vec3 = this.m_20184_();
        double d2 = vec3.m_165925_();
        double d3 = this.xPush * this.xPush + this.zPush * this.zPush;
        if (d3 > 1.0E-4 && d2 > 0.001) {
            double d4 = Math.sqrt(d2);
            double d5 = Math.sqrt(d3);
            this.xPush = vec3.f_82479_ / d4 * d5;
            this.zPush = vec3.f_82481_ / d4 * d5;
        }
    }

    protected void m_7114_() {
        double d0 = this.xPush * this.xPush + this.zPush * this.zPush;
        if (d0 > 1.0E-7) {
            d0 = Math.sqrt(d0);
            this.xPush /= d0;
            this.zPush /= d0;
            Vec3 vec3 = this.m_20184_().m_82542_(0.8, 0.0, 0.8).m_82520_(this.xPush, 0.0, this.zPush);
            if (this.m_20069_()) {
                vec3 = vec3.m_82490_(0.1);
            }
            this.m_20256_(vec3);
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.98, 0.0, 0.98));
        }
        super.m_7114_();
    }

    public InteractionResult m_6096_(Player p, InteractionHand ih) {
        InteractionResult ret = super.m_6096_(p, ih);
        if (ret.m_19077_()) {
            return ret;
        }
        ItemStack itemstack = p.m_21120_(ih);
        boolean flagIsLogsThatBurn = itemstack.m_204117_(ItemTags.f_13181_);
        boolean flagIsSigns = itemstack.m_204117_(ItemTags.f_13157_);
        boolean wd = itemstack.m_204117_(ItemTags.f_13173_);
        boolean wb = itemstack.m_204117_(ItemTags.f_13170_);
        boolean ws = itemstack.m_204117_(ItemTags.f_13175_);
        boolean wstairs = itemstack.m_204117_(ItemTags.f_13174_);
        boolean wtrapdoors = itemstack.m_204117_(ItemTags.f_13178_);
        boolean wp = itemstack.m_204117_(ItemTags.f_13177_);
        if ((INGREDIENTS.test(itemstack) || flagIsLogsThatBurn || flagIsSigns || wd || wb || ws || wstairs || wtrapdoors || wp) && this.fuel <= Short.MAX_VALUE) {
            if (!p.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
                p.m_6674_(ih);
            }
            this.fuel = this.maxFuel;
        }
        if (this.fuel > 0) {
            this.xPush = this.m_20185_() - p.m_20185_();
            this.zPush = this.m_20189_() - p.m_20189_();
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7380_(CompoundTag ctadd) {
        super.m_7380_(ctadd);
        ctadd.m_128347_("PushX", this.xPush);
        ctadd.m_128347_("PushZ", this.zPush);
        ctadd.m_128376_("Fuel", (short)this.fuel);
    }

    protected void m_7378_(CompoundTag ctread) {
        super.m_7378_(ctread);
        this.xPush = ctread.m_128459_("PushX");
        this.zPush = ctread.m_128459_("PushZ");
        this.fuel = ctread.m_128448_("Fuel");
    }

    protected boolean hasFuel() {
        return (Boolean)this.f_19804_.m_135370_(FUELED);
    }

    protected void setHasFuel(boolean p_38577_) {
        this.f_19804_.m_135381_(FUELED, (Object)p_38577_);
    }

    public boolean m_7337_(Entity ent) {
        return ent instanceof Player || ent instanceof Boat || ent instanceof AbstractMinecart;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    protected boolean m_7341_(Entity p_20339_) {
        return false;
    }

    public BlockState m_6390_() {
        return (BlockState)((Block)ThingamajigsBlocks.REFINED_THINGAMAJIG_BLOCK.get()).m_49966_().m_263224_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true));
    }
}

