/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.fluid.types;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PurifyingWaterFluidType
extends FluidType {
    private final float RED = 0.13725491f;
    private final float GREEN = 0.9019608f;
    private final float BLUE = 0.99607843f;
    private final Vector3f fogColor = new Vector3f(0.13725491f, 0.9019608f, 0.99607843f);

    public PurifyingWaterFluidType(FluidType.Properties properties) {
        super(FluidType.Properties.create().descriptionId("block.thingamajigs.purifying_water").fallDistanceModifier(0.0f).canExtinguish(true).supportsBoating(true).canHydrate(true).viscosity(1000).temperature(300).canConvertToSource(false).density(75).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11917_).rarity(Rarity.EPIC));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("thingamajigs:block/purifying_water_still");
            private static final ResourceLocation FLOWING_TEXTURE = new ResourceLocation("thingamajigs:block/purifying_water_flow");
            private static final ResourceLocation UNDERWATER_TEXTURE = new ResourceLocation("thingamajigs:textures/misc/purifying_water_underwater.png");
            private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("thingamajigs:textures/misc/overlay.png");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER_TEXTURE;
            }

            public int getTintColor() {
                return -587202561;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return OVERLAY_TEXTURE;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return PurifyingWaterFluidType.this.fogColor;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)1.0f);
                RenderSystem.setShaderFogEnd((float)20.0f);
            }
        });
    }
}

