/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.network.messages;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.rk.thingamajigs.events.ThingamajigsSoundEvents;
import net.rk.thingamajigs.network.ThingamajigsPacketHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PhoneUIButtonMessage {
    private int buttonID = 0;
    private int x = 0;
    private int y = 0;
    private int z = 0;

    public PhoneUIButtonMessage() {
    }

    public PhoneUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PhoneUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PhoneUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PhoneUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PhoneUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player ply, int buttonID, int x, int y, int z) {
        BlockPos bp;
        Level lvl = ply.m_9236_();
        if (!lvl.m_46805_(bp = new BlockPos(x, y, z))) {
            return;
        }
        if (!lvl.f_46443_) {
            if (buttonID == 0) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_ONE.get());
            } else if (buttonID == 1) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_TWO.get());
            } else if (buttonID == 2) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_THREE.get());
            } else if (buttonID == 3) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_FOUR.get());
            } else if (buttonID == 4) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_FIVE.get());
            } else if (buttonID == 5) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_SIX.get());
            } else if (buttonID == 6) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_SEVEN.get());
            } else if (buttonID == 7) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_EIGHT.get());
            } else if (buttonID == 8) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_NINE.get());
            } else if (buttonID == 9) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_POUND.get());
            } else if (buttonID == 10) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_ZER0.get());
            } else if (buttonID == 11) {
                PhoneUIButtonMessage.playLocalOrServerSound(false, lvl, bp, (SoundEvent)ThingamajigsSoundEvents.MOBILE_STAR.get());
            }
        }
    }

    public static void playLocalOrServerSound(boolean local, Level l, BlockPos p, SoundEvent event) {
        SoundSource ss1 = SoundSource.PLAYERS;
        if (local) {
            l.m_245747_(p, event, ss1, 1.0f, 1.0f, false);
        } else {
            l.m_5594_(null, p, event, ss1, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ThingamajigsPacketHandler.addNetworkMessage(PhoneUIButtonMessage.class, PhoneUIButtonMessage::buffer, PhoneUIButtonMessage::new, PhoneUIButtonMessage::handler);
    }
}

