/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.rk.thingamajigs.block.ThingamajigsBlocks;
import org.jetbrains.annotations.Nullable;

public class ThingamajigsCrafterRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;

    public ThingamajigsCrafterRecipe(NonNullList<Ingredient> inputItems, ItemStack output, ResourceLocation id) {
        this.inputItems = inputItems;
        this.output = output;
        this.id = id;
    }

    public boolean matches(SimpleContainer sc, Level l) {
        if (l.m_5776_()) {
            return false;
        }
        boolean itemOneOk = ((Ingredient)this.inputItems.get(0)).test(sc.m_8020_(0));
        boolean itemTwoOk = ((Ingredient)this.inputItems.get(1)).test(sc.m_8020_(1));
        boolean itemThreeOk = ((Ingredient)this.inputItems.get(2)).test(sc.m_8020_(2));
        boolean itemFourOk = ((Ingredient)this.inputItems.get(3)).test(sc.m_8020_(3));
        return itemOneOk && itemTwoOk && itemThreeOk && itemFourOk;
    }

    public ItemStack assemble(SimpleContainer sc, RegistryAccess ra) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int i1, int i2) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess ra1) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ThingamajigsBlocks.NOT_QUITE_MENGER.get());
    }

    public static class Serializer
    implements RecipeSerializer<ThingamajigsCrafterRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("thingamajigs", "thingamajigs_crafting");

        public ThingamajigsCrafterRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new ThingamajigsCrafterRecipe((NonNullList<Ingredient>)inputs, output, recipeId);
        }

        @Nullable
        public ThingamajigsCrafterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf fbuff) {
            NonNullList inputs = NonNullList.m_122780_((int)fbuff.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)fbuff));
            }
            ItemStack output = fbuff.m_130267_();
            return new ThingamajigsCrafterRecipe((NonNullList<Ingredient>)inputs, output, recipeId);
        }

        public void toNetwork(FriendlyByteBuf fbuff, ThingamajigsCrafterRecipe tcr) {
            fbuff.writeInt(tcr.inputItems.size());
            for (Ingredient ingredient : tcr.m_7527_()) {
                ingredient.m_43923_(fbuff);
            }
            fbuff.writeItemStack(tcr.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<ThingamajigsCrafterRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "thingamajigs_crafting";
    }
}

