/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.xtrablock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.rk.thingamajigs.entity.customblock.chests.StorageDecorationBE;
import org.jetbrains.annotations.Nullable;

public class StorageDecoration
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public final SoundEvent OPEN_CONTAINER_SOUND;
    public final boolean usesCustomModel;
    private String translatableName;

    public StorageDecoration(BlockBehaviour.Properties p) {
        super(p.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.OPEN_CONTAINER_SOUND = SoundEvents.f_12627_;
        this.usesCustomModel = false;
    }

    public StorageDecoration(BlockBehaviour.Properties p, SoundEvent openContainerSound) {
        super(p.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.OPEN_CONTAINER_SOUND = openContainerSound;
        this.usesCustomModel = false;
    }

    public StorageDecoration(BlockBehaviour.Properties p, SoundEvent openContainerSound, String translatableName) {
        super(p.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.OPEN_CONTAINER_SOUND = openContainerSound;
        this.usesCustomModel = false;
        this.translatableName = translatableName;
    }

    public StorageDecoration(BlockBehaviour.Properties p, String translatableName) {
        super(p.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.usesCustomModel = false;
        this.OPEN_CONTAINER_SOUND = SoundEvents.f_12627_;
        this.translatableName = translatableName;
    }

    public StorageDecoration(BlockBehaviour.Properties p, SoundEvent openContainerSound, boolean usesCustomModel) {
        super(p.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.OPEN_CONTAINER_SOUND = openContainerSound;
        this.usesCustomModel = usesCustomModel;
    }

    public RenderShape m_7514_(BlockState bs) {
        if (this.usesCustomModel) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState bs, Level lvl, BlockPos bp, BlockState bs2, boolean boo1) {
        BlockEntity blockEntity;
        if (bs.m_60734_() != bs2.m_60734_() && (blockEntity = lvl.m_7702_(bp)) instanceof StorageDecorationBE) {
            Containers.m_19002_((Level)lvl, (BlockPos)bp, (Container)((StorageDecorationBE)blockEntity));
        }
        super.m_6810_(bs, lvl, bp, bs2, boo1);
    }

    public InteractionResult m_6227_(BlockState bs, Level l, BlockPos bp, Player pl, InteractionHand h, BlockHitResult bhr) {
        if (l.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = l.m_7702_(bp);
        if (blockEntity instanceof StorageDecorationBE) {
            StorageDecorationBE be = (StorageDecorationBE)blockEntity;
            String str = be.getContainerNameTranslation();
            l.m_5594_(null, bp, this.OPEN_CONTAINER_SOUND, SoundSource.BLOCKS, 0.75f, 1.0f);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pl), (MenuProvider)((StorageDecorationBE)blockEntity), (BlockPos)bp);
            pl.m_6674_(h);
            return InteractionResult.CONSUME;
        }
        throw new IllegalStateException("StorageDecorationBE Container Provider is missing!");
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos bp, BlockState bs) {
        return new StorageDecorationBE(bp, bs, this.translatableName);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidstate) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState bs) {
        return (Boolean)bs.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(bs);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState bs, Direction dir, BlockState bs2, LevelAccessor lvla, BlockPos bp1, BlockPos bp2) {
        if (((Boolean)bs.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            lvla.m_186469_(bp1, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)lvla));
        }
        return super.m_7417_(bs, dir, bs2, lvla, bp1, bp2);
    }
}

