/*
 * Decompiled with CFR 0.152.
 */
package net.rk.thingamajigs.xtrablock;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rk.thingamajigs.block.ThingamajigsBlocks;
import net.rk.thingamajigs.entity.ChairEntity;
import net.rk.thingamajigs.interfacing.WeatheringCopperChair;
import net.rk.thingamajigs.xtrablock.ChairBlock;

public class WeatheringCopperChairBlock
extends Block
implements WeatheringCopperChair {
    private final WeatheringCopperChair.RustState ruststate;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public WeatheringCopperChairBlock(WeatheringCopperChair.RustState rs, BlockBehaviour.Properties p) {
        super(p.m_284180_(MapColor.f_283750_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_));
        this.ruststate = rs;
    }

    public void m_213898_(BlockState bs, ServerLevel sl, BlockPos bp, RandomSource rs1) {
        this.m_220947_(bs, sl, bp, rs1);
    }

    public boolean m_6724_(BlockState bsr1) {
        return WeatheringCopperChair.getNext(bsr1.m_60734_()).isPresent();
    }

    public WeatheringCopperChair.RustState getAge() {
        return this.ruststate;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter bg, BlockPos bp, CollisionContext cc) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return ChairBlock.NORTH;
            }
            case SOUTH: {
                return ChairBlock.SOUTH;
            }
            case EAST: {
                return ChairBlock.EAST;
            }
            case WEST: {
                return ChairBlock.WEST;
            }
        }
        return Shapes.m_83144_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState bs, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockState normal = ((Block)ThingamajigsBlocks.COPPER_CHAIR.get()).m_49966_();
        BlockState ok = ((Block)ThingamajigsBlocks.EXPOSED_COPPER_CHAIR.get()).m_49966_();
        BlockState bad = ((Block)ThingamajigsBlocks.WEATHERED_COPPER_CHAIR.get()).m_49966_();
        BlockState current = bs;
        boolean successful = false;
        if (player.m_21120_(hand).m_204117_(ItemTags.f_271207_)) {
            if (level.m_8055_(pos).m_60713_((Block)ThingamajigsBlocks.OXIDIZED_COPPER_CHAIR.get())) {
                level.m_7731_(pos, (BlockState)bad.m_61124_((Property)FACING, (Comparable)((Direction)current.m_61143_((Property)FACING))), 3);
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p_uh -> p_uh.m_21190_(hand));
                successful = true;
            } else if (level.m_8055_(pos).m_60713_((Block)ThingamajigsBlocks.WEATHERED_COPPER_CHAIR.get())) {
                level.m_7731_(pos, (BlockState)ok.m_61124_((Property)FACING, (Comparable)((Direction)current.m_61143_((Property)FACING))), 3);
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p_uh -> p_uh.m_21190_(hand));
                successful = true;
            } else if (level.m_8055_(pos).m_60713_((Block)ThingamajigsBlocks.EXPOSED_COPPER_CHAIR.get())) {
                level.m_7731_(pos, (BlockState)normal.m_61124_((Property)FACING, (Comparable)((Direction)current.m_61143_((Property)FACING))), 3);
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p_uh -> p_uh.m_21190_(hand));
                successful = true;
            }
            if (!successful) {
                return this.spawnChairPerhaps(pos, level, bs, player);
            }
            level.m_5594_(null, pos, SoundEvents.f_144059_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_175831_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            player.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        if (player.m_21120_(hand).m_150930_(Items.f_42784_)) {
            player.m_21120_(hand).m_41774_(1);
            this.applyWaxItemToBlock(bs, level, pos);
            level.m_245747_(pos, SoundEvents.f_144178_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_175828_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            player.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        return this.spawnChairPerhaps(pos, level, bs, player);
    }

    public InteractionResult spawnChairPerhaps(BlockPos pos, Level level, BlockState bs, Player player) {
        try {
            List chairs;
            double a = (double)pos.m_123341_() + 1.0;
            double b = (double)pos.m_123342_() + 1.0;
            double c = (double)pos.m_123343_() + 1.0;
            AABB aabb = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), a, b, c);
            if (!level.f_46443_ && (chairs = level.m_45976_(ChairEntity.class, aabb)).isEmpty()) {
                ChairEntity ce = ChairEntity.requestNewEntity(level, pos, bs);
                level.m_7967_((Entity)ce);
                player.m_7998_((Entity)ce, false);
            }
            this.playCustomSitSound(level, pos, player);
            return InteractionResult.SUCCESS;
        }
        catch (Exception e) {
            return InteractionResult.FAIL;
        }
    }

    public void applyWaxItemToBlock(BlockState bs, Level lvl, BlockPos bp) {
        BlockState w_normal = ((Block)ThingamajigsBlocks.WAXED_COPPER_CHAIR.get()).m_49966_();
        BlockState w_ok = ((Block)ThingamajigsBlocks.WAXED_EXPOSED_COPPER_CHAIR.get()).m_49966_();
        BlockState w_bad = ((Block)ThingamajigsBlocks.WAXED_WEATHERED_COPPER_CHAIR.get()).m_49966_();
        BlockState w_awful = ((Block)ThingamajigsBlocks.WAXED_OXIDIZED_COPPER_CHAIR.get()).m_49966_();
        if (bs.m_60713_((Block)ThingamajigsBlocks.OXIDIZED_COPPER_CHAIR.get())) {
            lvl.m_7731_(bp, (BlockState)w_awful.m_61124_((Property)FACING, (Comparable)((Direction)bs.m_61143_((Property)FACING))), 3);
        } else if (bs.m_60713_((Block)ThingamajigsBlocks.WEATHERED_COPPER_CHAIR.get())) {
            lvl.m_7731_(bp, (BlockState)w_bad.m_61124_((Property)FACING, (Comparable)((Direction)bs.m_61143_((Property)FACING))), 3);
        } else if (bs.m_60713_((Block)ThingamajigsBlocks.EXPOSED_COPPER_CHAIR.get())) {
            lvl.m_7731_(bp, (BlockState)w_ok.m_61124_((Property)FACING, (Comparable)((Direction)bs.m_61143_((Property)FACING))), 3);
        } else if (bs.m_60713_((Block)ThingamajigsBlocks.COPPER_CHAIR.get())) {
            lvl.m_7731_(bp, (BlockState)w_normal.m_61124_((Property)FACING, (Comparable)((Direction)bs.m_61143_((Property)FACING))), 3);
        }
    }

    public void playCustomSitSound(Level l, BlockPos bp, Player p) {
        SoundEvent event = SoundEvents.f_144120_;
        l.m_5594_(p, bp, event, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

