/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.counter.api;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.counter.api.CounterType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0004\b\u000f\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lus/timinc/mc/cobblemon/counter/api/CounterTypeRegistry;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/counter/api/CounterType;", "counterType", "registerCounterType", "(Lus/timinc/mc/cobblemon/counter/api/CounterType;)Lus/timinc/mc/cobblemon/counter/api/CounterType;", "", "type", "findByType", "(Ljava/lang/String;)Lus/timinc/mc/cobblemon/counter/api/CounterType;", "", "types", "()Ljava/util/List;", "counterTypes", "", "Ljava/util/Map;", "common"})
public final class CounterTypeRegistry {
    @NotNull
    public static final CounterTypeRegistry INSTANCE = new CounterTypeRegistry();
    @NotNull
    private static final Map<String, CounterType> counterTypes = new LinkedHashMap();

    private CounterTypeRegistry() {
    }

    @NotNull
    public final CounterType registerCounterType(@NotNull CounterType counterType) {
        Intrinsics.checkNotNullParameter((Object)counterType, (String)"counterType");
        if (counterTypes.containsKey(counterType.getType())) {
            throw new Error("Attempted to register Counter type " + counterType.getType() + " twice");
        }
        counterTypes.put(counterType.getType(), counterType);
        return counterType;
    }

    @NotNull
    public final CounterType findByType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CounterType counterType = counterTypes.get(type);
        Intrinsics.checkNotNull((Object)counterType);
        return counterType;
    }

    @NotNull
    public final List<String> types() {
        return CollectionsKt.toList((Iterable)counterTypes.keySet());
    }

    @NotNull
    public final List<CounterType> counterTypes() {
        return CollectionsKt.toList((Iterable)counterTypes.values());
    }
}

