/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.counter;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.api.scheduling.SchedulingTracker;
import com.cobblemon.mod.common.api.scheduling.ServerTaskTracker;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreType;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreTypes;
import com.cobblemon.mod.common.api.storage.player.client.ClientInstancedPlayerData;
import com.cobblemon.mod.common.client.tooltips.TooltipGenerator;
import com.cobblemon.mod.common.client.tooltips.TooltipManager;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.group.CobblemonItemGroups;
import com.cobblemon.mod.common.net.messages.client.SetClientPlayerDataPacket;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.platform.events.ServerEvent;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.counter.CounterMod;
import us.timinc.mc.cobblemon.counter.api.ClientCounterManager;
import us.timinc.mc.cobblemon.counter.api.CounterType;
import us.timinc.mc.cobblemon.counter.api.CounterTypeRegistry;
import us.timinc.mc.cobblemon.counter.api.ScoreType;
import us.timinc.mc.cobblemon.counter.api.ScoreTypeRegistry;
import us.timinc.mc.cobblemon.counter.command.AddScoreCommand;
import us.timinc.mc.cobblemon.counter.command.CounterCommand;
import us.timinc.mc.cobblemon.counter.command.GetFormScoreCommand;
import us.timinc.mc.cobblemon.counter.command.GetScoreCommand;
import us.timinc.mc.cobblemon.counter.command.GetSpeciesScoreCommand;
import us.timinc.mc.cobblemon.counter.command.ReduceScoreCommand;
import us.timinc.mc.cobblemon.counter.command.SetScoreCommand;
import us.timinc.mc.cobblemon.counter.command.argument.CounterTypeArgument;
import us.timinc.mc.cobblemon.counter.command.argument.ScoreTypeArgument;
import us.timinc.mc.cobblemon.counter.data.SpeciesFormOverride;
import us.timinc.mc.cobblemon.counter.event.BreakStreakEvent;
import us.timinc.mc.cobblemon.counter.event.RecordEvent;
import us.timinc.mc.cobblemon.counter.handler.BattleFaintedHandler;
import us.timinc.mc.cobblemon.counter.handler.CatchHandler;
import us.timinc.mc.cobblemon.counter.handler.EggHatchHandler;
import us.timinc.mc.cobblemon.counter.handler.FossilRevivedHandler;
import us.timinc.mc.cobblemon.counter.handler.PokemonEntitySpawnHandler;
import us.timinc.mc.cobblemon.counter.handler.ServerStartingHandler;
import us.timinc.mc.cobblemon.counter.item.CounterItem;
import us.timinc.mc.cobblemon.counter.item.CounterTooltipGenerator;
import us.timinc.mc.cobblemon.counter.scoretype.CountScoreType;
import us.timinc.mc.cobblemon.counter.scoretype.StreakScoreType;
import us.timinc.mc.cobblemon.timcore.AbstractCommand;
import us.timinc.mc.cobblemon.timcore.AbstractConfig;
import us.timinc.mc.cobblemon.timcore.AbstractMod;
import us.timinc.mc.cobblemon.timcore.CommandArgumentContainer;
import us.timinc.mc.cobblemon.timcore.ItemContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\b\n\u000b\f\r\u000e\u000f\u0010\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod;", "Lus/timinc/mc/cobblemon/timcore/AbstractMod;", "Lus/timinc/mc/cobblemon/counter/CounterMod$CounterConfig;", "<init>", "()V", "Lus/timinc/mc/cobblemon/counter/api/CounterType;", "counterType", "", "breakStreakOnForm", "(Lus/timinc/mc/cobblemon/counter/api/CounterType;)Z", "Commands", "CounterConfig", "CounterTypes", "Events", "Items", "PlayerInstancedDataStores", "SaveTasks", "ScoreTypes", "common"})
public final class CounterMod
extends AbstractMod<CounterConfig> {
    @NotNull
    public static final CounterMod INSTANCE = new CounterMod();

    private CounterMod() {
        super("cobbled_counter", CounterConfig.class);
    }

    public final boolean breakStreakOnForm(@NotNull CounterType counterType) {
        Intrinsics.checkNotNullParameter((Object)counterType, (String)"counterType");
        return ((CounterConfig)this.getConfig()).getBreakStreakOnForm().contains(counterType.getType());
    }

    static {
        PlatformEvents.SERVER_STARTING.subscribe(Priority.LOWEST, (Function1)new Function1<ServerEvent.Starting, Unit>((Object)ServerStartingHandler.INSTANCE){

            public final void invoke(@NotNull ServerEvent.Starting p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ServerStartingHandler)this.receiver).handle(p0);
            }
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.LOWEST, (Function1)new Function1<PokemonCapturedEvent, Unit>((Object)CatchHandler.INSTANCE){

            public final void invoke(@NotNull PokemonCapturedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((CatchHandler)this.receiver).handle(p0);
            }
        });
        CobblemonEvents.BATTLE_FAINTED.subscribe(Priority.LOWEST, (Function1)new Function1<BattleFaintedEvent, Unit>((Object)BattleFaintedHandler.INSTANCE){

            public final void invoke(@NotNull BattleFaintedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((BattleFaintedHandler)this.receiver).handle(p0);
            }
        });
        CobblemonEvents.FOSSIL_REVIVED.subscribe(Priority.LOWEST, (Function1)new Function1<FossilRevivedEvent, Unit>((Object)FossilRevivedHandler.INSTANCE){

            public final void invoke(@NotNull FossilRevivedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((FossilRevivedHandler)this.receiver).handle(p0);
            }
        });
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.LOWEST, (Function1)new Function1<SpawnEvent<PokemonEntity>, Unit>((Object)PokemonEntitySpawnHandler.INSTANCE){

            public final void invoke(@NotNull SpawnEvent<PokemonEntity> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((PokemonEntitySpawnHandler)this.receiver).handle(p0);
            }
        });
        CobblemonEvents.HATCH_EGG_POST.subscribe(Priority.LOWEST, (Function1)new Function1<HatchEggEvent.Post, Unit>((Object)EggHatchHandler.INSTANCE){

            public final void invoke(@NotNull HatchEggEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((EggHatchHandler)this.receiver).handle(p0);
            }
        });
        INSTANCE.registerReloadListener(SpeciesFormOverride.Manager.INSTANCE);
        TooltipManager.INSTANCE.registerTooltipGenerator((TooltipGenerator)CounterTooltipGenerator.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0007\u001a\u0004\b\f\u0010\tR\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u0007\u001a\u0004\b\u000f\u0010\tR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0007\u001a\u0004\b\u0012\u0010\tR\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0007\u001a\u0004\b\u0014\u0010\tR\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0007\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u0017"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod$Commands;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/timcore/AbstractCommand;", "Lus/timinc/mc/cobblemon/counter/command/CounterCommand$Data;", "ADD_SCORE_COMMAND", "Lus/timinc/mc/cobblemon/timcore/AbstractCommand;", "getADD_SCORE_COMMAND", "()Lus/timinc/mc/cobblemon/timcore/AbstractCommand;", "Lus/timinc/mc/cobblemon/counter/command/GetFormScoreCommand$Data;", "GET_FORM_SCORE_COMMAND", "getGET_FORM_SCORE_COMMAND", "Lus/timinc/mc/cobblemon/counter/command/GetScoreCommand$Data;", "GET_SCORE_COMMAND", "getGET_SCORE_COMMAND", "Lus/timinc/mc/cobblemon/counter/command/GetSpeciesScoreCommand$Data;", "GET_SPECIES_SCORE_COMMAND", "getGET_SPECIES_SCORE_COMMAND", "REDUCE_SCORE_COMMAND", "getREDUCE_SCORE_COMMAND", "SET_SCORE_COMMAND", "getSET_SCORE_COMMAND", "common"})
    public static final class Commands {
        @NotNull
        public static final Commands INSTANCE = new Commands();
        @NotNull
        private static final AbstractCommand<GetScoreCommand.Data> GET_SCORE_COMMAND;
        @NotNull
        private static final AbstractCommand<GetSpeciesScoreCommand.Data> GET_SPECIES_SCORE_COMMAND;
        @NotNull
        private static final AbstractCommand<GetFormScoreCommand.Data> GET_FORM_SCORE_COMMAND;
        @NotNull
        private static final AbstractCommand<CounterCommand.Data> ADD_SCORE_COMMAND;
        @NotNull
        private static final AbstractCommand<CounterCommand.Data> REDUCE_SCORE_COMMAND;
        @NotNull
        private static final AbstractCommand<CounterCommand.Data> SET_SCORE_COMMAND;

        private Commands() {
        }

        @NotNull
        public final AbstractCommand<GetScoreCommand.Data> getGET_SCORE_COMMAND() {
            return GET_SCORE_COMMAND;
        }

        @NotNull
        public final AbstractCommand<GetSpeciesScoreCommand.Data> getGET_SPECIES_SCORE_COMMAND() {
            return GET_SPECIES_SCORE_COMMAND;
        }

        @NotNull
        public final AbstractCommand<GetFormScoreCommand.Data> getGET_FORM_SCORE_COMMAND() {
            return GET_FORM_SCORE_COMMAND;
        }

        @NotNull
        public final AbstractCommand<CounterCommand.Data> getADD_SCORE_COMMAND() {
            return ADD_SCORE_COMMAND;
        }

        @NotNull
        public final AbstractCommand<CounterCommand.Data> getREDUCE_SCORE_COMMAND() {
            return REDUCE_SCORE_COMMAND;
        }

        @NotNull
        public final AbstractCommand<CounterCommand.Data> getSET_SCORE_COMMAND() {
            return SET_SCORE_COMMAND;
        }

        static {
            ResourceLocation resourceLocation = INSTANCE.modResource("counter_type");
            SingletonArgumentInfo singletonArgumentInfo = SingletonArgumentInfo.contextFree(CounterTypeArgument::new);
            Intrinsics.checkNotNullExpressionValue((Object)singletonArgumentInfo, (String)"contextFree(...)");
            INSTANCE.registerCommandArgument(new CommandArgumentContainer(resourceLocation, CounterTypeArgument.class, (ArgumentTypeInfo)singletonArgumentInfo));
            ResourceLocation resourceLocation2 = INSTANCE.modResource("score_type");
            SingletonArgumentInfo singletonArgumentInfo2 = SingletonArgumentInfo.contextFree(ScoreTypeArgument::new);
            Intrinsics.checkNotNullExpressionValue((Object)singletonArgumentInfo2, (String)"contextFree(...)");
            INSTANCE.registerCommandArgument(new CommandArgumentContainer(resourceLocation2, ScoreTypeArgument.class, (ArgumentTypeInfo)singletonArgumentInfo2));
            GET_SCORE_COMMAND = INSTANCE.registerCommand(GetScoreCommand.INSTANCE);
            GET_SPECIES_SCORE_COMMAND = INSTANCE.registerCommand(GetSpeciesScoreCommand.INSTANCE);
            GET_FORM_SCORE_COMMAND = INSTANCE.registerCommand(GetFormScoreCommand.INSTANCE);
            ADD_SCORE_COMMAND = INSTANCE.registerCommand(AddScoreCommand.INSTANCE);
            REDUCE_SCORE_COMMAND = INSTANCE.registerCommand(ReduceScoreCommand.INSTANCE);
            SET_SCORE_COMMAND = INSTANCE.registerCommand(SetScoreCommand.INSTANCE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0007\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod$CounterConfig;", "Lus/timinc/mc/cobblemon/timcore/AbstractConfig;", "<init>", "()V", "", "", "breakStreakOnForm", "Ljava/util/Set;", "getBreakStreakOnForm", "()Ljava/util/Set;", "broadcast", "getBroadcast", "common"})
    public static final class CounterConfig
    extends AbstractConfig {
        @NotNull
        private final Set<String> breakStreakOnForm = CollectionsKt.toSet((Iterable)CounterTypeRegistry.INSTANCE.types());
        @NotNull
        private final Set<String> broadcast = CollectionsKt.toSet((Iterable)CounterTypeRegistry.INSTANCE.types());

        @NotNull
        public final Set<String> getBreakStreakOnForm() {
            return this.breakStreakOnForm;
        }

        @NotNull
        public final Set<String> getBroadcast() {
            return this.broadcast;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0006\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod$CounterTypes;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/counter/api/CounterType;", "CAPTURE", "Lus/timinc/mc/cobblemon/counter/api/CounterType;", "getCAPTURE", "()Lus/timinc/mc/cobblemon/counter/api/CounterType;", "FISH", "getFISH", "HATCH", "getHATCH", "KO", "getKO", "RESURRECTION", "getRESURRECTION", "common"})
    public static final class CounterTypes {
        @NotNull
        public static final CounterTypes INSTANCE = new CounterTypes();
        @NotNull
        private static final CounterType CAPTURE = CounterTypeRegistry.INSTANCE.registerCounterType(new CounterType("capture"));
        @NotNull
        private static final CounterType KO = CounterTypeRegistry.INSTANCE.registerCounterType(new CounterType("ko"));
        @NotNull
        private static final CounterType RESURRECTION = CounterTypeRegistry.INSTANCE.registerCounterType(new CounterType("resurrection"));
        @NotNull
        private static final CounterType FISH = CounterTypeRegistry.INSTANCE.registerCounterType(new CounterType("fish"));
        @NotNull
        private static final CounterType HATCH = CounterTypeRegistry.INSTANCE.registerCounterType(new CounterType("hatch"));

        private CounterTypes() {
        }

        @NotNull
        public final CounterType getCAPTURE() {
            return CAPTURE;
        }

        @NotNull
        public final CounterType getKO() {
            return KO;
        }

        @NotNull
        public final CounterType getRESURRECTION() {
            return RESURRECTION;
        }

        @NotNull
        public final CounterType getFISH() {
            return FISH;
        }

        @NotNull
        public final CounterType getHATCH() {
            return HATCH;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0007R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod$Events;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/reactive/EventObservable;", "Lus/timinc/mc/cobblemon/counter/event/BreakStreakEvent$Post;", "BREAK_STREAK_POST", "Lcom/cobblemon/mod/common/api/reactive/EventObservable;", "Lcom/cobblemon/mod/common/api/reactive/CancelableObservable;", "Lus/timinc/mc/cobblemon/counter/event/BreakStreakEvent$Pre;", "BREAK_STREAK_PRE", "Lcom/cobblemon/mod/common/api/reactive/CancelableObservable;", "Lus/timinc/mc/cobblemon/counter/event/RecordEvent$Post;", "RECORD_POST", "Lus/timinc/mc/cobblemon/counter/event/RecordEvent$Pre;", "RECORD_PRE", "common"})
    public static final class Events {
        @NotNull
        public static final Events INSTANCE = new Events();
        @JvmField
        @NotNull
        public static final CancelableObservable<RecordEvent.Pre> RECORD_PRE = new CancelableObservable();
        @JvmField
        @NotNull
        public static final EventObservable<RecordEvent.Post> RECORD_POST = new EventObservable();
        @JvmField
        @NotNull
        public static final CancelableObservable<BreakStreakEvent.Pre> BREAK_STREAK_PRE = new CancelableObservable();
        @JvmField
        @NotNull
        public static final EventObservable<BreakStreakEvent.Post> BREAK_STREAK_POST = new EventObservable();

        private Events() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod$Items;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/timcore/ItemContainer;", "Lus/timinc/mc/cobblemon/counter/item/CounterItem;", "COUNTER", "Lus/timinc/mc/cobblemon/timcore/ItemContainer;", "getCOUNTER", "()Lus/timinc/mc/cobblemon/timcore/ItemContainer;", "common"})
    public static final class Items {
        @NotNull
        public static final Items INSTANCE = new Items();
        @NotNull
        private static final ItemContainer<CounterItem> COUNTER = INSTANCE.registerItem("counter", new ItemContainer((Function0)COUNTER.1.INSTANCE, CobblemonItemGroups.getUTILITY_ITEMS_KEY()));

        private Items() {
        }

        @NotNull
        public final ItemContainer<CounterItem> getCOUNTER() {
            return COUNTER;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod$PlayerInstancedDataStores;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;", "COUNTER", "Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;", "getCOUNTER", "()Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;", "common"})
    public static final class PlayerInstancedDataStores {
        @NotNull
        public static final PlayerInstancedDataStores INSTANCE = new PlayerInstancedDataStores();
        @NotNull
        private static final PlayerInstancedDataStoreType COUNTER = PlayerInstancedDataStoreTypes.INSTANCE.register(new PlayerInstancedDataStoreType(INSTANCE.modResource("counter"), (Function1)new Function1<RegistryFriendlyByteBuf, SetClientPlayerDataPacket>((Object)ClientCounterManager.Companion){

            @NotNull
            public final SetClientPlayerDataPacket invoke(@NotNull RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ClientCounterManager.Companion)this.receiver).decode(p0);
            }
        }, (Function1)new Function1<ClientInstancedPlayerData, Unit>((Object)ClientCounterManager.Companion){

            public final void invoke(@NotNull ClientInstancedPlayerData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ClientCounterManager.Companion)this.receiver).runAction(p0);
            }
        }, (Function1)new Function1<ClientInstancedPlayerData, Unit>((Object)ClientCounterManager.Companion){

            public final void invoke(@NotNull ClientInstancedPlayerData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ClientCounterManager.Companion)this.receiver).runActionIncremental(p0);
            }
        }));

        private PlayerInstancedDataStores() {
        }

        @NotNull
        public final PlayerInstancedDataStoreType getCOUNTER() {
            return COUNTER;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod$SaveTasks;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "SAVE_COUNTER", "Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "getSAVE_COUNTER", "()Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "common"})
    public static final class SaveTasks {
        @NotNull
        public static final SaveTasks INSTANCE = new SaveTasks();
        @NotNull
        private static final ScheduledTask SAVE_COUNTER = new ScheduledTask.Builder().execute((Function1)SAVE_COUNTER.1.INSTANCE).delay(30.0f).interval(120.0f).infiniteIterations().tracker((SchedulingTracker)ServerTaskTracker.INSTANCE).build();

        private SaveTasks() {
        }

        @NotNull
        public final ScheduledTask getSAVE_COUNTER() {
            return SAVE_COUNTER;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lus/timinc/mc/cobblemon/counter/CounterMod$ScoreTypes;", "", "<init>", "()V", "Lus/timinc/mc/cobblemon/counter/api/ScoreType;", "COUNT", "Lus/timinc/mc/cobblemon/counter/api/ScoreType;", "getCOUNT", "()Lus/timinc/mc/cobblemon/counter/api/ScoreType;", "STREAK", "getSTREAK", "common"})
    public static final class ScoreTypes {
        @NotNull
        public static final ScoreTypes INSTANCE = new ScoreTypes();
        @NotNull
        private static final ScoreType COUNT = ScoreTypeRegistry.INSTANCE.registerScoreType(new CountScoreType("count"));
        @NotNull
        private static final ScoreType STREAK = ScoreTypeRegistry.INSTANCE.registerScoreType(new StreakScoreType("streak"));

        private ScoreTypes() {
        }

        @NotNull
        public final ScoreType getCOUNT() {
            return COUNT;
        }

        @NotNull
        public final ScoreType getSTREAK() {
            return STREAK;
        }
    }
}

