/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client;

import com.leon.saintsdragons.client.ui.DragonStatusUI;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;

public class DragonStatusUIManager {
    private static DragonStatusUIManager instance;
    private final DragonStatusUI dragonStatusUI = new DragonStatusUI();
    private DragonEntity lastRiddenDragon = null;
    private int lastScreenWidth = 0;
    private int lastScreenHeight = 0;

    private DragonStatusUIManager() {
    }

    public static DragonStatusUIManager getInstance() {
        if (instance == null) {
            instance = new DragonStatusUIManager();
        }
        return instance;
    }

    public void update() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        if (minecraft.m_91268_() != null) {
            int currentWidth = minecraft.m_91268_().m_85445_();
            int currentHeight = minecraft.m_91268_().m_85446_();
            if (currentWidth != this.lastScreenWidth || currentHeight != this.lastScreenHeight) {
                this.lastScreenWidth = currentWidth;
                this.lastScreenHeight = currentHeight;
                this.dragonStatusUI.onWindowResize();
            }
        }
        LocalPlayer player = minecraft.f_91074_;
        DragonEntity currentDragon = null;
        if (player != null && player.m_20202_() instanceof DragonEntity) {
            currentDragon = (DragonEntity)player.m_20202_();
        }
        if (currentDragon != this.lastRiddenDragon) {
            this.dragonStatusUI.updateDragon(currentDragon);
            this.lastRiddenDragon = currentDragon;
            if (currentDragon == null && this.dragonStatusUI.isVisible()) {
                this.dragonStatusUI.setVisible(false);
            }
        }
    }

    public DragonStatusUI getDragonStatusUI() {
        return this.dragonStatusUI;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.dragonStatusUI.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.dragonStatusUI.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.dragonStatusUI.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }
}

