/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.stegonaut;

import com.leon.saintsdragons.SaintsDragons;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class StegonautModel
extends DefaultedEntityGeoModel<Stegonaut> {
    private static final ResourceLocation MALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/stegonaut/stegonaut.png");
    private static final ResourceLocation FEMALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/stegonaut/stegonaut_female.png");

    public StegonautModel() {
        super(SaintsDragons.rl("stegonaut"), "head");
    }

    public ResourceLocation getTextureResource(Stegonaut entity) {
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public void setCustomAnimations(Stegonaut entity, long instanceId, AnimationState<Stegonaut> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        float partialTick = animationState.getPartialTick();
        this.applyBodyRotationDeviation(entity, partialTick);
        this.applyTailDrag(entity, partialTick);
    }

    private void applyBodyRotationDeviation(Stegonaut entity, float partialTick) {
        Optional rootOpt = this.getBone("root");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyTailDrag(Stegonaut entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-30.0, (double)30.0);
        float velocityRad = (float)(velocity * 0.01745329238474369);
        this.applyTailBoneRotation("tail1", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail2", velocityRad * 2.5f);
        this.applyTailBoneRotation("tail3", velocityRad * 3.0f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }
}

