/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.cindervane;

import com.leon.saintsdragons.client.model.cindervane.CindervaneModel;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CindervaneRenderer
extends GeoEntityRenderer<Cindervane> {
    private static final float PASSENGER_SEAT0_X = 0.0f;
    private static final float PASSENGER_SEAT0_Y = -3.0f;
    private static final float PASSENGER_SEAT0_Z = 0.0f;
    private static final float PASSENGER_SEAT1_X = 0.0f;
    private static final float PASSENGER_SEAT1_Y = -3.0f;
    private static final float PASSENGER_SEAT1_Z = 0.0f;
    private BakedGeoModel lastBakedModel;

    public CindervaneRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CindervaneModel());
    }

    protected float getDeathMaxRotation(Cindervane entity) {
        return 0.0f;
    }

    public void preRender(PoseStack poseStack, Cindervane entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float scale = 1.0f;
        poseStack.m_85841_(scale, scale, scale);
        this.f_114477_ = 2.0f * scale;
        this.lastBakedModel = model;
        this.enableTrackingForBones(model);
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void enableTrackingForBones(BakedGeoModel model) {
        model.getBone("passengerBone1").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("passengerBone2").ifPresent(b -> b.setTrackingMatrices(true));
    }

    public void render(@NotNull Cindervane entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        if (this.lastBakedModel != null) {
            this.lastBakedModel.getBone("passengerBone1").ifPresent(b -> {
                Vec3 world = this.transformLocator((GeoBone)b, 0.0f, -3.0f, 0.0f);
                if (world != null) {
                    entity.setClientLocatorPosition("passengerSeat0", world);
                }
            });
            this.lastBakedModel.getBone("passengerBone2").ifPresent(b -> {
                Vec3 world = this.transformLocator((GeoBone)b, 0.0f, -3.0f, 0.0f);
                if (world != null) {
                    entity.setClientLocatorPosition("passengerSeat1", world);
                }
            });
        }
    }

    private Vec3 transformLocator(GeoBone bone, float px, float py, float pz) {
        if (bone == null || bone.getWorldSpaceMatrix() == null) {
            return null;
        }
        float lx = px / 16.0f;
        float ly = py / 16.0f;
        float lz = pz / 16.0f;
        Matrix4f worldMat = new Matrix4f((Matrix4fc)bone.getWorldSpaceMatrix());
        Vector4f in = new Vector4f(lx, ly, lz, 1.0f);
        Vector4f out = worldMat.transform(in);
        return new Vec3((double)out.x(), (double)out.y(), (double)out.z());
    }
}

