/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.item;

import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NulljawBinderItem
extends Item {
    private static final String BOUND_DRAGON_UUID = "BoundDragonUUID";
    private static final String BOUND_DRAGON_NAME = "BoundDragonName";
    private static final String BOUND_OWNER_UUID = "BoundOwnerUUID";
    private static final String BOUND_OWNER_NAME = "BoundOwnerName";
    private static final String BOUND_CUSTOM_NAME = "BoundCustomName";
    private static final String DRAGON_DATA_KEY = "RiftDrakeData";
    private static final String IS_BOUND = "IsBound";

    public NulljawBinderItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (!(target instanceof Nulljaw)) {
            return InteractionResult.PASS;
        }
        Nulljaw drake = (Nulljaw)target;
        if (!drake.m_21824_() || !drake.m_21830_((LivingEntity)player)) {
            player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.not_dragon_owner"), true);
            return InteractionResult.FAIL;
        }
        if (!drake.canBeBound()) {
            player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.nulljaw_cannot_be_captured"), true);
            return InteractionResult.FAIL;
        }
        if (NulljawBinderItem.isBound(stack)) {
            player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.binder_already_occupied"), true);
            return InteractionResult.FAIL;
        }
        ItemStack newStack = this.captureDrake(stack, drake, player);
        if (hand == InteractionHand.MAIN_HAND) {
            player.m_150109_().m_6836_(player.m_150109_().f_35977_, newStack);
        } else {
            player.m_150109_().m_6836_(40, newStack);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return NulljawBinderItem.isBound(stack) ? InteractionResultHolder.m_19098_((Object)stack) : super.m_7203_(level, player, hand);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return super.m_6225_(context);
        }
        ItemStack stack = context.m_43722_();
        if (!NulljawBinderItem.isBound(stack)) {
            return super.m_6225_(context);
        }
        return this.releaseDrake(stack, player, context.m_8083_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private ItemStack captureDrake(ItemStack stack, Nulljaw drake, Player player) {
        ItemStack copied = stack.m_41777_();
        CompoundTag tag = copied.m_41784_();
        tag.m_128362_(BOUND_DRAGON_UUID, drake.m_20148_());
        tag.m_128359_(BOUND_DRAGON_NAME, drake.m_7755_().getString());
        if (drake.m_8077_()) {
            tag.m_128359_(BOUND_CUSTOM_NAME, Component.Serializer.m_130703_((Component)drake.m_7770_()));
        } else {
            tag.m_128473_(BOUND_CUSTOM_NAME);
        }
        tag.m_128379_(IS_BOUND, true);
        LivingEntity owner = drake.m_269323_();
        if (owner instanceof Player) {
            Player ownerPlayer = (Player)owner;
            tag.m_128362_(BOUND_OWNER_UUID, ownerPlayer.m_20148_());
            tag.m_128359_(BOUND_OWNER_NAME, ownerPlayer.m_7755_().getString());
        } else {
            tag.m_128473_(BOUND_OWNER_UUID);
            tag.m_128473_(BOUND_OWNER_NAME);
        }
        CompoundTag drakeData = new CompoundTag();
        drake.m_7380_(drakeData);
        tag.m_128365_(DRAGON_DATA_KEY, (Tag)drakeData);
        copied.m_41751_(tag);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                if (serverPlayer.m_150109_().m_8020_(i) != stack) continue;
                serverPlayer.m_150109_().m_6836_(i, copied);
                break;
            }
        }
        drake.m_142687_(Entity.RemovalReason.DISCARDED);
        player.m_5661_((Component)Component.m_237110_((String)"saintsdragons.message.nulljaw_captured", (Object[])new Object[]{drake.m_7755_().getString()}), true);
        return copied;
    }

    private boolean releaseDrake(ItemStack stack, Player player, BlockPos pos) {
        MutableComponent customName;
        UUID ownerUUID;
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(BOUND_DRAGON_UUID)) {
            return false;
        }
        UUID uUID = ownerUUID = tag.m_128441_(BOUND_OWNER_UUID) ? tag.m_128342_(BOUND_OWNER_UUID) : null;
        if (ownerUUID != null && !player.m_20148_().equals(ownerUUID)) {
            player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.cannot_release_others_dragon"), true);
            return false;
        }
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String drakeName = tag.m_128461_(BOUND_DRAGON_NAME);
        Nulljaw newDrake = new Nulljaw((EntityType<? extends Nulljaw>)((EntityType)ModEntities.NULLJAW.get()), (Level)serverLevel);
        if (tag.m_128441_(DRAGON_DATA_KEY)) {
            CompoundTag drakeData = tag.m_128469_(DRAGON_DATA_KEY);
            newDrake.m_7378_(drakeData);
        }
        newDrake.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
        if (ownerUUID != null) {
            Player owner = serverLevel.m_46003_(ownerUUID);
            if (owner != null) {
                newDrake.m_21828_(owner);
            } else {
                newDrake.m_7105_(true);
                newDrake.m_21816_(ownerUUID);
            }
        } else {
            newDrake.m_21828_(player);
        }
        if (tag.m_128441_(BOUND_CUSTOM_NAME) && (customName = Component.Serializer.m_130701_((String)tag.m_128461_(BOUND_CUSTOM_NAME))) != null) {
            newDrake.m_6593_((Component)customName);
        }
        serverLevel.m_7967_((Entity)newDrake);
        tag.m_128473_(BOUND_DRAGON_UUID);
        tag.m_128473_(BOUND_DRAGON_NAME);
        tag.m_128473_(BOUND_OWNER_UUID);
        tag.m_128473_(BOUND_OWNER_NAME);
        tag.m_128473_(BOUND_CUSTOM_NAME);
        tag.m_128473_(DRAGON_DATA_KEY);
        tag.m_128379_(IS_BOUND, false);
        player.m_5661_((Component)Component.m_237110_((String)"saintsdragons.message.nulljaw_released", (Object[])new Object[]{drakeName}), true);
        return true;
    }

    public static boolean isBound(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(IS_BOUND);
    }

    @Nullable
    public static UUID getBoundRiftDrakeUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(BOUND_DRAGON_UUID)) {
            return tag.m_128342_(BOUND_DRAGON_UUID);
        }
        return null;
    }

    @Nullable
    public static String getBoundRiftDrakeName(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(BOUND_DRAGON_NAME)) {
            return tag.m_128461_(BOUND_DRAGON_NAME);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"saintsdragons.tooltip.nulljaw.description"));
        if (NulljawBinderItem.isBound(stack)) {
            String name = NulljawBinderItem.getBoundRiftDrakeName(stack);
            if (name != null && !name.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"saintsdragons.tooltip.nulljaw.bound", (Object[])new Object[]{name}));
            }
            tooltip.add((Component)Component.m_237115_((String)"saintsdragons.tooltip.nulljaw.right_click_to_release"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"saintsdragons.tooltip.nulljaw.empty"));
            tooltip.add((Component)Component.m_237115_((String)"saintsdragons.tooltip.nulljaw.right_click_nulljaw_to_bind"));
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return NulljawBinderItem.isBound(stack);
    }
}

