/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.client.screen.DragonAllyScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageDragonAllyList {
    private final int dragonId;
    private final List<String> allyList;

    public MessageDragonAllyList(int dragonId, List<String> allyList) {
        this.dragonId = dragonId;
        this.allyList = new ArrayList<String>(allyList);
    }

    public MessageDragonAllyList(FriendlyByteBuf buffer) {
        this.dragonId = buffer.readInt();
        int size = buffer.readInt();
        this.allyList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            this.allyList.add(buffer.m_130136_(16));
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dragonId);
        buffer.writeInt(this.allyList.size());
        for (String ally : this.allyList) {
            buffer.m_130072_(ally, 16);
        }
    }

    public static void handle(MessageDragonAllyList message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                Minecraft minecraft = Minecraft.m_91087_();
                Screen patt1762$temp = minecraft.f_91080_;
                if (patt1762$temp instanceof DragonAllyScreen) {
                    DragonAllyScreen allyScreen = (DragonAllyScreen)patt1762$temp;
                    allyScreen.updateAllyList(message.allyList);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

