/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.common.network.MessageDragonAllyList;
import com.leon.saintsdragons.common.network.ModNetworkHandler;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageDragonAllyRequest {
    private final int dragonId;

    public MessageDragonAllyRequest(int dragonId) {
        this.dragonId = dragonId;
    }

    public MessageDragonAllyRequest(FriendlyByteBuf buffer) {
        this.dragonId = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dragonId);
    }

    public static void handle(MessageDragonAllyRequest message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Entity entity = player.m_9236_().m_6815_(message.dragonId);
            if (!(entity instanceof DragonEntity)) {
                return;
            }
            DragonEntity dragon = (DragonEntity)entity;
            if (!dragon.m_21824_() || !dragon.m_21830_((LivingEntity)player)) {
                return;
            }
            ModNetworkHandler.sendToPlayer(player, new MessageDragonAllyList(dragon.m_19879_(), dragon.allyManager.getAllyUsernames()));
        });
        context.setPacketHandled(true);
    }
}

