/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.server.entity.interfaces.DragonControlStateHolder;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record MessageDragonControl(int dragonId, byte controlState) {
    public static void encode(MessageDragonControl message, FriendlyByteBuf buf) {
        buf.writeInt(message.dragonId());
        buf.writeByte((int)message.controlState());
    }

    public static MessageDragonControl decode(FriendlyByteBuf buf) {
        return new MessageDragonControl(buf.readInt(), buf.readByte());
    }

    public static void handle(MessageDragonControl message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            DragonControlStateHolder holder;
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.m_9236_().m_6815_(message.dragonId())) instanceof DragonControlStateHolder && (holder = (DragonControlStateHolder)entity).canPlayerModifyControlState((Player)player)) {
                holder.setControlState(message.controlState());
            }
        });
        context.setPacketHandled(true);
    }
}

