/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record MessageDragonRideInput(boolean goingUp, boolean goingDown, DragonRiderAction action, String abilityName, float forward, float strafe, float yaw) {
    public boolean hasAbilityName() {
        return this.abilityName != null && !this.abilityName.isEmpty();
    }

    public static void encode(MessageDragonRideInput msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.goingUp());
        buf.writeBoolean(msg.goingDown());
        buf.m_130068_((Enum)(msg.action() != null ? msg.action() : DragonRiderAction.NONE));
        if (msg.action() == DragonRiderAction.ABILITY_USE || msg.action() == DragonRiderAction.ABILITY_STOP) {
            buf.m_130070_(msg.abilityName() != null ? msg.abilityName() : "");
        }
        buf.writeFloat(msg.forward());
        buf.writeFloat(msg.strafe());
        buf.writeFloat(msg.yaw());
    }

    public static MessageDragonRideInput decode(FriendlyByteBuf buf) {
        boolean goingUp = buf.readBoolean();
        boolean goingDown = buf.readBoolean();
        DragonRiderAction action = (DragonRiderAction)buf.m_130066_(DragonRiderAction.class);
        String abilityName = null;
        if ((action == DragonRiderAction.ABILITY_USE || action == DragonRiderAction.ABILITY_STOP) && (abilityName = buf.m_130277_()).isEmpty()) {
            abilityName = null;
        }
        float forward = buf.readFloat();
        float strafe = buf.readFloat();
        float yaw = buf.readFloat();
        return new MessageDragonRideInput(goingUp, goingDown, action, abilityName, forward, strafe, yaw);
    }

    public static void handle(MessageDragonRideInput msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            RideableDragonBase dragon;
            Entity vehicle;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (vehicle = player.m_20202_()) instanceof RideableDragonBase && (dragon = (RideableDragonBase)vehicle).canBeControlledBy((Player)player)) {
                dragon.handleRiderNetworkInput(player, msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

