/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.base;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class DragonSleepGoalBase
extends Goal {
    protected final DragonEntity dragon;
    protected final DragonSleepCapable sleepCapable;

    public DragonSleepGoalBase(DragonEntity dragon) {
        this.dragon = dragon;
        this.sleepCapable = (DragonSleepCapable)((Object)dragon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        Stegonaut drake;
        if (this.agitated()) {
            return false;
        }
        if (this.sleepCapable.isSleepSuppressed()) {
            return false;
        }
        DragonEntity dragonEntity = this.dragon;
        if (dragonEntity instanceof Stegonaut && (drake = (Stegonaut)dragonEntity).isPlayingDead()) {
            return false;
        }
        if (!this.sleepCapable.canSleepNow()) {
            return false;
        }
        if (this.dragon.m_21824_()) {
            return this.canTamedDragonSleep();
        }
        return this.canWildDragonSleep();
    }

    public boolean m_8045_() {
        Stegonaut drake;
        if (this.agitated()) {
            return false;
        }
        DragonEntity dragonEntity = this.dragon;
        if (dragonEntity instanceof Stegonaut && (drake = (Stegonaut)dragonEntity).isPlayingDead()) {
            return false;
        }
        if (this.sleepCapable.isSleepSuppressed()) {
            return false;
        }
        if (this.dragon.m_21824_()) {
            return this.canTamedDragonSleep();
        }
        DragonSleepCapable.SleepPreferences prefs = this.sleepCapable.getSleepPreferences();
        if (prefs.canSleepAtNight() && !prefs.canSleepDuringDay() && this.isDay()) {
            return false;
        }
        if (prefs.canSleepDuringDay() && !prefs.canSleepAtNight() && this.isNight()) {
            return false;
        }
        return this.canWildDragonSleep();
    }

    public void m_8056_() {
        this.sleepCapable.startSleepEnter();
    }

    public void m_8041_() {
        this.sleepCapable.startSleepExit();
    }

    protected boolean agitated() {
        if (this.dragon.m_20072_() || this.dragon.m_20077_()) {
            return true;
        }
        return this.dragon.m_21224_() || this.dragon.m_20160_() || this.dragon.m_5448_() != null || this.dragon.m_5912_();
    }

    protected boolean canTamedDragonSleep() {
        DragonSleepCapable.SleepPreferences prefs = this.sleepCapable.getSleepPreferences();
        if (prefs.avoidsThunderstorms() && this.dragon.m_9236_().m_46470_()) {
            return false;
        }
        if (this.ownerSleeping()) {
            return true;
        }
        return prefs.sleepsNearOwner() && this.isNight() && this.nearOwner();
    }

    protected boolean canWildDragonSleep() {
        DragonSleepCapable.SleepPreferences prefs = this.sleepCapable.getSleepPreferences();
        if (prefs.canSleepDuringDay() && this.isDay() && this.isSheltered()) {
            return !prefs.avoidsThunderstorms() || !this.dragon.m_9236_().m_46470_();
        }
        if (prefs.canSleepAtNight() && this.isNight() && this.isSheltered()) {
            return !prefs.avoidsThunderstorms() || !this.dragon.m_9236_().m_46470_();
        }
        return false;
    }

    protected boolean isDay() {
        return this.dragon.m_9236_().m_46461_();
    }

    protected boolean isNight() {
        return !this.dragon.m_9236_().m_46461_();
    }

    protected boolean ownerSleeping() {
        Player p;
        LivingEntity owner = this.dragon.m_269323_();
        return owner instanceof Player && (p = (Player)owner).m_5803_();
    }

    protected boolean nearOwner() {
        LivingEntity owner = this.dragon.m_269323_();
        return owner != null && this.dragon.m_20280_((Entity)owner) <= 196.0;
    }

    protected boolean isSheltered() {
        BlockPos pos;
        Level level = this.dragon.m_9236_();
        boolean noSky = !level.m_45527_(pos = this.dragon.m_20183_());
        int light = level.m_46803_(pos);
        return noSky || light < 7;
    }
}

