/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.cindervane;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class CindervaneRestGoal
extends Goal {
    private final Cindervane amphithere;
    private int retryCooldown;
    private RestState state;
    private int stateTimer;

    public CindervaneRestGoal(Cindervane amphithere) {
        this.amphithere = amphithere;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        boolean isNight;
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.amphithere.m_21824_()) {
            return false;
        }
        if (this.amphithere.m_21827_()) {
            return false;
        }
        if (this.amphithere.isSleepLocked()) {
            return false;
        }
        if (this.amphithere.m_20072_() || this.amphithere.m_20077_()) {
            return false;
        }
        if (this.amphithere.isDying() || this.amphithere.m_20160_()) {
            return false;
        }
        if (this.amphithere.m_5448_() != null || this.amphithere.m_5912_()) {
            return false;
        }
        if (this.amphithere.m_29443_()) {
            return false;
        }
        long dayTime = this.amphithere.m_9236_().m_46468_() % 24000L;
        boolean bl = isNight = dayTime >= 13000L && dayTime < 23000L;
        if (!isNight) {
            return false;
        }
        return this.amphithere.m_217043_().m_188501_() < 5.0E-4f;
    }

    public boolean m_8045_() {
        boolean safeToRest = !this.amphithere.m_20072_() && this.amphithere.m_5448_() == null;
        boolean sequenceComplete = this.state == RestState.STANDING_UP && this.stateTimer > 46;
        long dayTime = this.amphithere.m_9236_().m_46468_() % 24000L;
        boolean isNight = dayTime >= 13000L && dayTime < 23000L;
        return !sequenceComplete && safeToRest && isNight;
    }

    public void m_8056_() {
        this.stateTimer = 0;
        this.state = RestState.SITTING_DOWN;
        this.amphithere.m_21839_(true);
        this.amphithere.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.amphithere.m_9236_().f_46443_) {
            return;
        }
        ++this.stateTimer;
        this.amphithere.m_21573_().m_26573_();
        this.amphithere.m_20334_(0.0, this.amphithere.m_20184_().f_82480_, 0.0);
        if (!(this.state != RestState.SITTING_DOWN && this.state != RestState.SITTING || this.amphithere.m_21827_())) {
            this.amphithere.m_21839_(true);
        }
        switch (this.state) {
            case SITTING_DOWN: {
                if (this.stateTimer <= 50 || this.amphithere.isInSitTransition()) break;
                this.state = RestState.SITTING;
                this.stateTimer = 0;
                break;
            }
            case SITTING: {
                if (this.stateTimer <= 20) break;
                this.state = RestState.FALLING_ASLEEP;
                this.stateTimer = 0;
                this.amphithere.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.amphithere.m_5803_() || this.amphithere.isSleepTransitioning()) && this.stateTimer <= 65) break;
                this.state = RestState.SLEEPING;
                this.stateTimer = 0;
                break;
            }
            case SLEEPING: {
                boolean isNight;
                long dayTime = this.amphithere.m_9236_().m_46468_() % 24000L;
                boolean bl = isNight = dayTime >= 13000L && dayTime < 23000L;
                if (isNight) break;
                this.state = RestState.WAKING_UP;
                this.stateTimer = 0;
                this.amphithere.startSleepExit();
                this.amphithere.m_21839_(true);
                break;
            }
            case WAKING_UP: {
                if (this.stateTimer <= 47) break;
                this.state = RestState.SITTING_AFTER;
                this.stateTimer = 0;
                this.amphithere.m_21839_(true);
                break;
            }
            case SITTING_AFTER: {
                if (this.stateTimer <= 20) break;
                this.state = RestState.STANDING_UP;
                this.stateTimer = 0;
                this.amphithere.m_21839_(false);
                break;
            }
        }
    }

    public void m_8041_() {
        if (this.state != RestState.STANDING_UP) {
            if (this.amphithere.m_5803_() || this.amphithere.isSleepTransitioning()) {
                this.amphithere.startSleepExit();
            }
            this.amphithere.m_21839_(false);
        }
        this.retryCooldown = 400 + this.amphithere.m_217043_().m_188503_(401);
        this.stateTimer = 0;
        this.state = null;
    }

    public boolean m_6767_() {
        return true;
    }

    private static enum RestState {
        SITTING_DOWN,
        SITTING,
        FALLING_ASLEEP,
        SLEEPING,
        WAKING_UP,
        SITTING_AFTER,
        STANDING_UP;

    }
}

