/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.common.registry.nulljaw.NulljawAbilities;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.ability.abilities.nulljaw.NulljawClawAbility;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;

public class NulljawCombatGoal
extends Goal {
    private static final double CHASE_SPEED = 1.15;
    private static final double BITE_RANGE = 2.8;
    private static final double HORN_RANGE = 4.6;
    private static final int MIN_ATTACK_COOLDOWN_TICKS = 10;
    private final Nulljaw drake;
    private int attackCooldown;

    public NulljawCombatGoal(Nulljaw drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.drake.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.drake.m_20160_() || this.drake.m_21827_()) {
            return false;
        }
        return this.isWithinAggroRange(target);
    }

    public boolean m_8045_() {
        LivingEntity target = this.drake.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.drake.m_20160_() || this.drake.m_21827_()) {
            return false;
        }
        return this.isWithinAggroRange(target);
    }

    public void m_8056_() {
        this.attackCooldown = 0;
        LivingEntity target = this.drake.m_5448_();
        if (target != null) {
            this.drake.m_21573_().m_5624_((Entity)target, 1.15);
            this.drake.m_21561_(true);
        }
    }

    public void m_8041_() {
        this.drake.m_21573_().m_26573_();
        this.drake.m_21561_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if ((target = this.drake.m_5448_()) == null) {
            return;
        }
        this.drake.m_21563_().m_24960_((Entity)target, 35.0f, 35.0f);
        double distanceSq = this.drake.m_20280_((Entity)target);
        double attackReachSq = this.getAttackReachSqr(target);
        boolean inRange = distanceSq <= attackReachSq;
        boolean hasLineOfSight = this.drake.m_21574_().m_148306_((Entity)target);
        if (!inRange || !hasLineOfSight) {
            if (!this.isPerformingAttack()) {
                this.drake.m_21573_().m_5624_((Entity)target, 1.15);
            }
            return;
        }
        this.drake.m_21573_().m_26573_();
        this.tryPerformAttacks(target);
    }

    private void tryPerformAttacks(LivingEntity target) {
        DragonAbilityType<Nulljaw, NulljawClawAbility> claw;
        if (this.attackCooldown > 0) {
            return;
        }
        DragonAbilityType<Nulljaw, ?> ability = this.choosePrimaryAttack(target);
        if (ability != null && this.drake.combatManager.canStart(ability)) {
            this.drake.combatManager.tryUseAbility(ability);
            this.attackCooldown = 10;
        }
        if (this.shouldUseClaw() && this.drake.combatManager.canStart(claw = NulljawAbilities.NULLJAW_CLAW)) {
            this.drake.combatManager.tryUseAbility(claw);
        }
    }

    private DragonAbilityType<Nulljaw, ?> choosePrimaryAttack(LivingEntity target) {
        double gap = this.getGapToTarget(target);
        boolean phaseTwo = this.drake.isPhaseTwoActive();
        if (gap <= 2.8) {
            return phaseTwo ? NulljawAbilities.NULLJAW_BITE2 : NulljawAbilities.NULLJAW_BITE;
        }
        if (gap <= 4.6) {
            return NulljawAbilities.NULLJAW_HORN_GORE;
        }
        return null;
    }

    private boolean shouldUseClaw() {
        return this.drake.isPhaseTwoActive() && !this.drake.m_20160_() && !this.drake.combatManager.isAbilityActive(NulljawAbilities.NULLJAW_CLAW);
    }

    private boolean isPerformingAttack() {
        return this.drake.getActiveAbility() != null || this.drake.combatManager.isAbilityActive(NulljawAbilities.NULLJAW_CLAW);
    }

    private boolean isWithinAggroRange(LivingEntity target) {
        double followRange = this.drake.m_21133_(Attributes.f_22277_);
        if (followRange <= 0.0) {
            followRange = 16.0;
        }
        double maxDistanceSq = followRange * followRange;
        return this.drake.m_20280_((Entity)target) <= maxDistanceSq;
    }

    private double getAttackReachSqr(LivingEntity target) {
        double combinedRadii = (double)(this.drake.m_20205_() + target.m_20205_()) * 0.5;
        double reach = 4.6 + combinedRadii;
        return reach * reach;
    }

    private double getGapToTarget(LivingEntity target) {
        double distance = this.drake.m_20270_((Entity)target);
        double combinedRadii = (double)(this.drake.m_20205_() + target.m_20205_()) * 0.5;
        return Math.max(0.0, distance - combinedRadii);
    }
}

